/*
 * Decompiled with CFR 0.152.
 */
package gw.config;

import gw.config.DefaultGlobalLoaderProvider;
import gw.config.DefaultGosuInitializationHooks;
import gw.config.DefaultGosuProfilingService;
import gw.config.IExtensionFolderLocator;
import gw.config.IGlobalLoaderProvider;
import gw.config.IGosuInitializationHooks;
import gw.config.IGosuLocalizationService;
import gw.config.IGosuProfilingService;
import gw.config.IMemoryMonitor;
import gw.config.IPlatformHelper;
import gw.config.IXmlSchemaCompatibilityConfig;
import gw.config.Registry;
import gw.config.ServiceKernel;
import gw.lang.IGosuShop;
import gw.lang.parser.ICoercionManager;
import gw.lang.parser.IGosuParserFactory;
import gw.lang.reflect.IEntityAccess;
import gw.lang.reflect.ITypeSystem;
import gw.lang.reflect.module.IFileSystem;
import java.lang.reflect.Constructor;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CommonServices
extends ServiceKernel {
    private static CommonServices _kernel = new CommonServices();
    private static ITypeSystem _typeSystem;
    private static IFileSystem _fileSystem;

    private CommonServices() {
        Registry.addLocationListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                _kernel.resetKernel();
            }
        });
    }

    @Override
    protected void defineServices() {
        _kernel = this;
        try {
            this.defineService(IFileSystem.class, CommonServices.getDefaultFileSystemInstance());
            this.defineService(IEntityAccess.class, (IEntityAccess)Class.forName("gw.internal.gosu.parser.DefaultEntityAccess").newInstance());
            _typeSystem = (ITypeSystem)Class.forName("gw.internal.gosu.parser.TypeLoaderAccess").newInstance();
            this.defineService(ICoercionManager.class, (ICoercionManager)Class.forName("gw.lang.parser.StandardCoercionManager").newInstance());
            this.defineService(IGosuParserFactory.class, (IGosuParserFactory)Class.forName("gw.internal.gosu.parser.GosuParserFactoryImpl").newInstance());
            this.defineService(IGosuShop.class, (IGosuShop)Class.forName("gw.internal.gosu.parser.GosuIndustrialParkImpl").newInstance());
            this.defineService(IGosuLocalizationService.class, (IGosuLocalizationService)Class.forName("gw.internal.gosu.DefaultLocalizationService").newInstance());
            this.defineService(IXmlSchemaCompatibilityConfig.class, (IXmlSchemaCompatibilityConfig)Class.forName("gw.config.DefaultXmlSchemaCompatibilityConfig").newInstance());
            this.defineService(IPlatformHelper.class, (IPlatformHelper)Class.forName("gw.internal.gosu.parser.DefaultPlatformHelper").newInstance());
            this.defineService(IExtensionFolderLocator.class, (IExtensionFolderLocator)Class.forName("gw.config.DefaultExtensionFolderLocator").newInstance());
            this.defineService(IMemoryMonitor.class, (IMemoryMonitor)Class.forName("gw.internal.gosu.memory.DefaultMemoryMonitor").newInstance());
            this.defineService(IGosuInitializationHooks.class, new DefaultGosuInitializationHooks());
            this.defineService(IGlobalLoaderProvider.class, new DefaultGlobalLoaderProvider());
            this.defineService(IGosuProfilingService.class, new DefaultGosuProfilingService());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
            throw e;
        }
    }

    private static IFileSystem getDefaultFileSystemInstance() {
        try {
            Class<?> cls = Class.forName("gw.internal.gosu.module.fs.FileSystemImpl");
            Constructor<?> m = cls.getConstructor(IFileSystem.CachingMode.class);
            return (IFileSystem)m.newInstance(new Object[]{IFileSystem.CachingMode.FULL_CACHING});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void redefineServices() {
        this.redefineServicesWithClass(Registry.instance().getCommonServiceInit());
    }

    public static IEntityAccess getEntityAccess() {
        return _kernel.getService(IEntityAccess.class);
    }

    public static ICoercionManager getCoercionManager() {
        return _kernel.getService(ICoercionManager.class);
    }

    public static IGosuProfilingService getGosuProfilingService() {
        return _kernel.getService(IGosuProfilingService.class);
    }

    public static ITypeSystem getTypeSystem() {
        return _typeSystem;
    }

    public static void sneakySetTypeSystem(ITypeSystem typeSystem) {
        _typeSystem = typeSystem;
    }

    public static IGosuParserFactory getGosuParserFactory() {
        return _kernel.getService(IGosuParserFactory.class);
    }

    public static IGosuShop getGosuIndustrialPark() {
        return _kernel.getService(IGosuShop.class);
    }

    public static IGosuLocalizationService getGosuLocalizationService() {
        return _kernel.getService(IGosuLocalizationService.class);
    }

    public static IXmlSchemaCompatibilityConfig getXmlSchemaCompatibilityConfig() {
        return _kernel.getService(IXmlSchemaCompatibilityConfig.class);
    }

    public static IPlatformHelper getPlatformHelper() {
        return _kernel.getService(IPlatformHelper.class);
    }

    public static IGosuInitializationHooks getGosuInitializationHooks() {
        return _kernel.getService(IGosuInitializationHooks.class);
    }

    public static IGlobalLoaderProvider getGlobalLoaderProvider() {
        return _kernel.getService(IGlobalLoaderProvider.class);
    }

    public static IExtensionFolderLocator getExtensionFolderLocator() {
        return _kernel.getService(IExtensionFolderLocator.class);
    }

    public static IFileSystem getFileSystem() {
        return _kernel.getService(IFileSystem.class);
    }

    public static IMemoryMonitor getMemoryMonitor() {
        return _kernel.getService(IMemoryMonitor.class);
    }

    public static CommonServices getKernel() {
        return _kernel;
    }

    static {
        _fileSystem = CommonServices.getDefaultFileSystemInstance();
    }
}

