/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.lang.GosuShop;
import gw.lang.reflect.FeatureManager;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IDefaultArrayType;
import gw.lang.reflect.IEventInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.MethodList;
import gw.lang.reflect.TypeInfoBase;
import gw.util.concurrent.LockingLazyVar;
import java.util.Collections;
import java.util.List;

public class DefaultArrayTypeInfo
extends TypeInfoBase
implements IRelativeTypeInfo {
    private IType _type;
    private LockingLazyVar<List<IPropertyInfo>> _declaredProperties;
    private final FeatureManager _fm;

    public DefaultArrayTypeInfo(IDefaultArrayType type) {
        this._type = type;
        this._declaredProperties = new LockingLazyVar<List<IPropertyInfo>>(){

            @Override
            protected List<IPropertyInfo> init() {
                return Collections.singletonList(GosuShop.createLengthProperty(DefaultArrayTypeInfo.this));
            }
        };
        this._fm = new FeatureManager(this, true);
    }

    protected void unloadTypeInfo() {
        this._fm.clear();
    }

    @Override
    public List<? extends IPropertyInfo> getProperties() {
        return this.getProperties(null);
    }

    @Override
    public IPropertyInfo getProperty(CharSequence propName) {
        return this.getProperty(null, propName);
    }

    @Override
    public MethodList getMethods() {
        return this.getMethods(null);
    }

    @Override
    public List<? extends IConstructorInfo> getConstructors() {
        return this.getDeclaredConstructors();
    }

    @Override
    public List<? extends IEventInfo> getEvents() {
        return this.getOwnersType().getSupertype().getTypeInfo().getEvents();
    }

    @Override
    public IEventInfo getEvent(CharSequence strEvent) {
        return this.getOwnersType().getSupertype().getTypeInfo().getEvent(strEvent);
    }

    @Override
    public List<IAnnotationInfo> getDeclaredAnnotations() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasAnnotation(IType type) {
        return false;
    }

    @Override
    public boolean isDefaultImpl() {
        return false;
    }

    @Override
    public IType getOwnersType() {
        return this._type;
    }

    @Override
    public IRelativeTypeInfo.Accessibility getAccessibilityForType(IType whosaskin) {
        return IRelativeTypeInfo.Accessibility.PUBLIC;
    }

    @Override
    public List<? extends IConstructorInfo> getDeclaredConstructors() {
        return Collections.emptyList();
    }

    @Override
    public List<? extends IMethodInfo> getDeclaredMethods() {
        return MethodList.EMPTY;
    }

    @Override
    public List<? extends IPropertyInfo> getDeclaredProperties() {
        return this._declaredProperties.get();
    }

    @Override
    public IConstructorInfo getConstructor(IType whosAskin, IType[] params) {
        List<? extends IConstructorInfo> ctors = this.getConstructors(whosAskin);
        return ITypeInfo.FIND.constructor(ctors, params);
    }

    @Override
    public List<? extends IConstructorInfo> getConstructors(IType whosaskin) {
        return this._fm.getConstructors(this.getAccessibilityForType(whosaskin));
    }

    @Override
    public IMethodInfo getMethod(IType whosaskin, CharSequence methodName, IType ... params) {
        MethodList methods = this.getMethods(whosaskin);
        return ITypeInfo.FIND.method(methods, methodName, params);
    }

    @Override
    public MethodList getMethods(IType whosaskin) {
        return this._fm.getMethods(this.getAccessibilityForType(whosaskin));
    }

    @Override
    public IPropertyInfo getProperty(IType whosaskin, CharSequence propName) {
        return this._fm.getProperty(this.getAccessibilityForType(whosaskin), propName);
    }

    @Override
    public List<? extends IPropertyInfo> getProperties(IType whosaskin) {
        return this._fm.getProperties(this.getAccessibilityForType(whosaskin));
    }

    @Override
    public String getName() {
        return this._type.getRelativeName();
    }

    @Override
    public String getDisplayName() {
        return this._type.getComponentType().getTypeInfo().getDisplayName() + "[]";
    }

    @Override
    public String getDescription() {
        return "Array of " + this._type.getComponentType().getRelativeName() + " objects";
    }
}

