/*
 * Decompiled with CFR 0.152.
 */
package gw.fs.physical;

import gw.fs.ResourcePath;
import gw.fs.physical.AbstractCachingPhysicalFileSystem;
import gw.fs.physical.IFileMetadata;
import gw.fs.physical.IPhysicalFileSystem;
import gw.lang.UnstableAPI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@UnstableAPI
public class FullCachingPhysicalFileSystem
extends AbstractCachingPhysicalFileSystem {
    private Map<String, DirCacheInfo> _dirCache = new HashMap<String, DirCacheInfo>();
    private Lock _lock = new ReentrantLock();

    public FullCachingPhysicalFileSystem(IPhysicalFileSystem delegate) {
        super(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<? extends IFileMetadata> listFiles(ResourcePath directoryPath) {
        this._lock.lock();
        try {
            String pathString = directoryPath.getPathString();
            DirCacheInfo cacheInfo = this._dirCache.get(pathString);
            if (cacheInfo == null) {
                cacheInfo = new DirCacheInfo(directoryPath);
                this._dirCache.put(pathString, cacheInfo);
            }
            List list = cacheInfo._files;
            return list;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public IFileMetadata getFileMetadata(ResourcePath filePath) {
        return this._delegate.getFileMetadata(filePath);
    }

    @Override
    public void clearDirectoryCaches(ResourcePath dirPath) {
        this._lock.lock();
        try {
            this._dirCache.remove(dirPath.getPathString());
        }
        finally {
            this._lock.unlock();
        }
        this._delegate.clearDirectoryCaches(dirPath);
    }

    @Override
    public void clearAllCaches() {
        this._lock.lock();
        try {
            this._dirCache.clear();
        }
        finally {
            this._lock.unlock();
        }
        this._delegate.clearAllCaches();
    }

    private class DirCacheInfo {
        private List<? extends IFileMetadata> _files;

        private DirCacheInfo(ResourcePath absolutePath) {
            this._files = FullCachingPhysicalFileSystem.this._delegate.listFiles(absolutePath);
        }
    }
}

