/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.util;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class RabinKarpHash {
    private static final int A = 31;
    private final int _block;
    private final int _Apowblock;
    private Set<Integer> _hashes = new HashSet<Integer>();
    private String[] _patterns;
    private static int[] CHAR_HASHES = new int[65536];

    public RabinKarpHash(String ... patterns) {
        this._block = RabinKarpHash.minLen(patterns);
        int apowbl = 1;
        for (int i = 0; i < this._block; ++i) {
            apowbl *= 31;
        }
        this._Apowblock = apowbl;
        this._patterns = patterns;
        for (String pattern : patterns) {
            int hash = this.reverseHash(pattern);
            this._hashes.add(hash);
        }
    }

    private static int minLen(String ... patterns) {
        int minLen = patterns[0].length();
        for (String str : patterns) {
            if (str.length() >= minLen) continue;
            minLen = str.length();
        }
        return minLen;
    }

    public boolean matches(String str) {
        int len = str.length();
        if (len < this._block) {
            return false;
        }
        int hash = this.reverseHash(str);
        for (int i = 0; i < len - this._block; ++i) {
            if (this._hashes.contains(hash) && this.exactMatch(str, i)) {
                return true;
            }
            hash = this.rollHash(hash, str, i);
        }
        return this._hashes.contains(hash) && this.exactMatch(str, len - this._block);
    }

    private boolean exactMatch(String str, int i) {
        int end = str.length() - i;
        for (String p : this._patterns) {
            int start = end - p.length();
            if (start < 0 || !str.regionMatches(start, p, 0, p.length())) continue;
            return true;
        }
        return false;
    }

    private int rollHash(int hashvalue, String str, int i) {
        char outchar = str.charAt(str.length() - 1 - i);
        char inchar = str.charAt(str.length() - this._block - 1 - i);
        hashvalue = 31 * hashvalue + CHAR_HASHES[inchar] - this._Apowblock * CHAR_HASHES[outchar];
        return hashvalue;
    }

    private int reverseHash(String str) {
        int hash = 0;
        int len = str.length();
        for (int i = 0; i < this._block; ++i) {
            char c = str.charAt(len - i - 1);
            hash = 31 * hash + CHAR_HASHES[c];
        }
        return hash;
    }

    static {
        Random r = new Random();
        for (int k = 0; k < CHAR_HASHES.length; ++k) {
            RabinKarpHash.CHAR_HASHES[k] = r.nextInt();
        }
    }
}

