/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.gosuc;

import gw.fs.IDirectory;
import gw.lang.gosuc.GosucDependency;
import gw.lang.gosuc.GosucProjectParser;
import gw.lang.gosuc.GosucUtil;
import gw.lang.parser.IToken;
import gw.lang.reflect.module.INativeModule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class GosucModule
implements INativeModule,
Serializable {
    private String _name;
    private List<String> _allSourceRoots = new ArrayList<String>();
    private List<String> _excludedRoots;
    private List<String> _classpath;
    private String _outputPath;
    private List<GosucDependency> _dependencies;

    public GosucModule(String name, List<String> allSourceRoots, List<String> classpath, String outputPath, List<GosucDependency> dependencies, List<String> excludedRoots) {
        for (String sourceRoot : allSourceRoots) {
            if (sourceRoot.endsWith(".jar")) continue;
            this._allSourceRoots.add(sourceRoot);
        }
        this._excludedRoots = new ArrayList<String>(excludedRoots);
        this._classpath = classpath;
        this._outputPath = outputPath;
        this._dependencies = dependencies;
        this._name = name;
    }

    public List<String> getAllSourceRoots() {
        return this._allSourceRoots;
    }

    public List<String> getExcludedRoots() {
        return this._excludedRoots;
    }

    public List<String> getClasspath() {
        return this._classpath;
    }

    public List<GosucDependency> getDependencies() {
        return this._dependencies;
    }

    public String getName() {
        return this._name;
    }

    @Override
    public Object getNativeModule() {
        return this;
    }

    @Override
    public IDirectory getOutputPath() {
        return this._outputPath != null ? GosucUtil.getDirectoryForPath(this._outputPath) : null;
    }

    public String write() {
        return this.getName() + " {\n" + "  sourcepath {\n" + this.writeRoots(this.getAllSourceRoots()) + "  }\n" + "  excludedpath {\n" + this.writeRoots(this.getExcludedRoots()) + "  }\n" + "  classpath {\n" + this.writeClasspath() + "  }\n" + "  outpath {\n" + this.writeOutputPath() + "  }\n" + "  deps {\n" + this.writeDependencies() + "  }\n" + "}\n";
    }

    private String writeRoots(List<String> roots) {
        StringBuilder sb = new StringBuilder();
        for (String sourceRoot : roots) {
            sb.append("    ").append("\"").append(sourceRoot).append("\",\n");
        }
        return sb.toString();
    }

    private String writeClasspath() {
        StringBuilder sb = new StringBuilder();
        for (String path : this.getClasspath()) {
            sb.append("    ").append("\"").append(path).append("\",\n");
        }
        return sb.toString();
    }

    private String writeOutputPath() {
        return this._outputPath != null ? "    \"" + this._outputPath + "\"\n" : "    \"\"\n";
    }

    private String writeDependencies() {
        StringBuilder sb = new StringBuilder();
        for (GosucDependency dep : this.getDependencies()) {
            sb.append("    ").append(dep.write()).append("\n");
        }
        return sb.toString();
    }

    public static GosucModule parse(GosucProjectParser parser) {
        IToken t = parser.getTokenizer().getCurrentToken();
        parser.verify(parser.match(null, -5, false), "Expecting module name");
        String name = t.getStringValue();
        parser.verify(parser.match(null, 123, false), "Expecting '{' to begin module definition");
        List<String> sourcepaths = GosucModule.parsePaths("sourcepath", parser);
        List<String> excludedRoots = GosucModule.parsePaths("excludedpath", parser);
        List<String> classpath = GosucModule.parseClasspath(parser);
        String outputPath = GosucModule.parseOutputPath(parser);
        List<GosucDependency> deps = GosucModule.parseDependencies(parser);
        parser.verify(parser.match(null, 125, false), "Expecting '}' to close module definition");
        return new GosucModule(name, sourcepaths, classpath, outputPath, deps, excludedRoots);
    }

    private static List<GosucDependency> parseDependencies(GosucProjectParser parser) {
        parser.verify(parser.matchWord("deps", false), "Expecting keyword 'deps'");
        parser.verify(parser.match(null, 123, false), "Expecting '{' to begin deps list");
        List<GosucDependency> deps = GosucModule.parseDependenciesList(parser);
        parser.verify(parser.match(null, 125, false), "Expecting '}' to close deps list");
        return deps;
    }

    private static List<GosucDependency> parseDependenciesList(GosucProjectParser parser) {
        ArrayList<GosucDependency> deps = new ArrayList<GosucDependency>();
        while (parser.match(null, -5, true)) {
            deps.add(GosucDependency.parse(parser));
        }
        return deps;
    }

    private static List<String> parseClasspath(GosucProjectParser parser) {
        parser.verify(parser.matchWord("classpath", false), "Expecting keyword 'classpath'");
        parser.verify(parser.match(null, 123, false), "Expecting '{' to begin classpath list");
        List<String> classpaths = GosucModule.parseClasspathList(parser);
        parser.verify(parser.match(null, 125, false), "Expecting '}' to close classpath list");
        return classpaths;
    }

    private static List<String> parseClasspathList(GosucProjectParser parser) {
        ArrayList<String> paths = new ArrayList<String>();
        IToken t = parser.getTokenizer().getCurrentToken();
        while (parser.match(null, 34, false)) {
            paths.add(t.getStringValue());
            if (!parser.match(null, 44, false)) break;
            t = parser.getTokenizer().getCurrentToken();
        }
        return paths;
    }

    private static List<String> parsePaths(String word, GosucProjectParser parser) {
        parser.verify(parser.matchWord(word, false), "Expecting keyword 'sourcepath'");
        parser.verify(parser.match(null, 123, false), "Expecting '{' to begin " + word + " list");
        List<String> sourcepaths = GosucModule.parseSourcePathList(parser);
        parser.verify(parser.match(null, 125, false), "Expecting '}' to close " + word + " list");
        return sourcepaths;
    }

    private static List<String> parseSourcePathList(GosucProjectParser parser) {
        ArrayList<String> paths = new ArrayList<String>();
        IToken t = parser.getTokenizer().getCurrentToken();
        while (parser.match(null, 34, false)) {
            paths.add(t.getStringValue());
            if (!parser.match(null, 44, false)) break;
            t = parser.getTokenizer().getCurrentToken();
        }
        return paths;
    }

    private static String parseOutputPath(GosucProjectParser parser) {
        parser.verify(parser.matchWord("outpath", false), "Expecting keyword 'outpath'");
        parser.verify(parser.match(null, 123, false), "Expecting '{' to begin outpath list");
        IToken t = parser.getTokenizer().getCurrentToken();
        parser.verify(parser.match(null, 34, false), "Expecting quoted path");
        parser.verify(parser.match(null, 125, false), "Expecting '}' to close outpath list");
        String value = t.getStringValue();
        return value.trim().isEmpty() ? null : value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GosucModule that = (GosucModule)o;
        if (!this._allSourceRoots.equals(that._allSourceRoots)) {
            return false;
        }
        if (!this._excludedRoots.equals(that._excludedRoots)) {
            return false;
        }
        if (!this._classpath.equals(that._classpath)) {
            return false;
        }
        if (!this._dependencies.equals(that._dependencies)) {
            return false;
        }
        if (!this._name.equals(that._name)) {
            return false;
        }
        return !(this._outputPath != null ? !this._outputPath.equals(that._outputPath) : that._outputPath != null);
    }

    public int hashCode() {
        int result = this._name.hashCode();
        result = 31 * result + this._allSourceRoots.hashCode();
        result = 31 * result + this._excludedRoots.hashCode();
        result = 31 * result + this._classpath.hashCode();
        result = 31 * result + (this._outputPath != null ? this._outputPath.hashCode() : 0);
        result = 31 * result + this._dependencies.hashCode();
        return result;
    }
}

