/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.gosuc.simple;

import gw.config.BaseService;
import gw.config.IMemoryMonitor;
import gw.lang.reflect.RefreshRequest;
import gw.lang.reflect.TypeSystem;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;

public class CompilerMemoryMonitor
extends BaseService
implements IMemoryMonitor {
    private static double usedMemoryRatio;

    public CompilerMemoryMonitor() {
        Timer timer = new Timer(true);
        timer.schedule(new TimerTask(){
            private LinkedList<Double> stack = new LinkedList();

            @Override
            public void run() {
                Runtime runtime = Runtime.getRuntime();
                double freeMem = (double)runtime.freeMemory() * 1.0E-9;
                double totalMem = (double)runtime.totalMemory() * 1.0E-9;
                double maxMem = (double)runtime.maxMemory() * 1.0E-9;
                double usedMem = totalMem - freeMem;
                double ratio = usedMem / maxMem;
                this.stack.addFirst(ratio);
                if (this.stack.size() > 5) {
                    this.stack.removeLast();
                }
                double averageRatio = 0.0;
                for (Double v : this.stack) {
                    averageRatio += v.doubleValue();
                }
                usedMemoryRatio = averageRatio / (double)this.stack.size();
            }
        }, 1000L, 1000L);
    }

    @Override
    public void reclaimMemory(RefreshRequest request) {
        if (usedMemoryRatio > 0.9 && usedMemoryRatio > 0.9) {
            TypeSystem.refresh(true);
            System.gc();
        }
    }
}

