/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.init;

import gw.fs.IDirectory;
import gw.lang.UnstableAPI;
import java.util.List;

@UnstableAPI
public class GosuPathEntry {
    private IDirectory _root;
    private List<? extends IDirectory> _srcs;

    public GosuPathEntry(IDirectory root, List<? extends IDirectory> srcs) {
        if (root == null) {
            throw new IllegalArgumentException("The root argument cannot be null");
        }
        if (srcs == null) {
            throw new IllegalArgumentException("The srcs argument cannot be null");
        }
        this._root = root;
        this._srcs = srcs;
    }

    public IDirectory getRoot() {
        return this._root;
    }

    public List<? extends IDirectory> getSources() {
        return this._srcs;
    }

    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GosuPathEntry:\n");
        sb.append("  root: ").append(this._root.toJavaFile().getAbsolutePath()).append("\n");
        for (IDirectory iDirectory : this._srcs) {
            sb.append("  src: ").append(iDirectory.toJavaFile().getAbsolutePath()).append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        return this._root.toString();
    }
}

