/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.ir.builder;

import gw.lang.GosuShop;
import gw.lang.UnstableAPI;
import gw.lang.ir.IRClass;
import gw.lang.ir.IRType;
import gw.lang.ir.IRTypeConstants;
import gw.lang.ir.SyntheticIRType;
import gw.lang.ir.builder.IRBuilderMethods;
import gw.lang.ir.builder.IRExpressionBuilder;
import gw.lang.ir.builder.IRFeatureBuilder;
import gw.lang.ir.builder.IRFieldBuilder;
import gw.lang.ir.builder.IRMethodBuilder;
import gw.lang.ir.statement.IRFieldDecl;
import gw.lang.ir.statement.IRMethodStatement;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.IJavaClassInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

@UnstableAPI
public class IRClassBuilder
extends IRFeatureBuilder<IRClassBuilder> {
    private IRType _thisType;
    private String _name;
    private IRType _superType;
    private List<IRMethodStatement> _methods = new ArrayList<IRMethodStatement>();
    private List<IRFieldDecl> _fields = new ArrayList<IRFieldDecl>();
    private List<IRType> _interfaces = new ArrayList<IRType>();

    public IRClassBuilder(String name, Class superType) {
        this._name = name;
        this._superType = this.getIRType(superType);
        String relativeName = name.substring(name.lastIndexOf(46) + 1);
        this._thisType = new SyntheticIRType(superType, name, relativeName);
        this._public();
    }

    public IRType getThisType() {
        return this._thisType;
    }

    public List<IRFieldDecl> getFields() {
        return this._fields;
    }

    public List<IRMethodStatement> getMethods() {
        return this._methods;
    }

    public IRType getSuperType() {
        return this._superType;
    }

    public IRMethodBuilder createMethod() {
        return new IRMethodBuilder(this);
    }

    public IRMethodBuilder createConstructor() {
        return new IRMethodBuilder(this).name("<init>").returns(IRTypeConstants.pVOID());
    }

    public void addDefaultConstructor() {
        ((IRMethodBuilder)new IRMethodBuilder(this)._public()).name("<init>").returns(IRTypeConstants.pVOID()).body(IRBuilderMethods._superInit(new IRExpressionBuilder[0]), IRBuilderMethods._return());
    }

    public IRFieldBuilder createField() {
        return new IRFieldBuilder(this);
    }

    public IRClassBuilder withField(IRFieldDecl field) {
        this._fields.add(field);
        return this;
    }

    public IRClassBuilder withMethod(IRMethodStatement method) {
        this._methods.add(method);
        return this;
    }

    public IRClassBuilder withInterface(Class type) {
        return this.withInterface(this.getIRType(type));
    }

    public IRClassBuilder withInterface(IJavaClassInfo type) {
        return this.withInterface(this.getIRType(type));
    }

    public IRClassBuilder withInterface(IType type) {
        return this.withInterface(this.getIRType(type));
    }

    public IRClassBuilder withInterface(IRType type) {
        this._interfaces.add(type);
        return this;
    }

    public IRClassBuilder asAbstract() {
        this._modifiers |= 0x400;
        return this;
    }

    public IRClassBuilder asInterface() {
        this.asAbstract();
        this._modifiers |= 0x200;
        return this;
    }

    public IRClass build() {
        IRClass irClass = new IRClass();
        irClass.setName(this._name);
        irClass.setSuperType(this._superType);
        irClass.setThisType(this._thisType);
        irClass.setModifiers(this._modifiers);
        for (IRType iface : this._interfaces) {
            irClass.addInterface(iface);
        }
        for (IRFieldDecl field : this._fields) {
            irClass.addField(field);
        }
        for (IRMethodStatement method : this._methods) {
            irClass.addMethod(method);
        }
        return irClass;
    }

    public Class define(ClassLoader classLoader) {
        IRClass irClass = this.build();
        byte[] bytes = GosuShop.getIRClassCompiler().compile(irClass, false);
        return this.defineClassInLoader(classLoader, irClass.getName(), bytes);
    }

    private Class defineClassInLoader(ClassLoader classLoader, String name, byte[] bytes) {
        try {
            Method method = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            method.setAccessible(true);
            return (Class)method.invoke((Object)classLoader, name, bytes, 0, bytes.length);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

