/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.ir.builder.expression;

import gw.lang.UnstableAPI;
import gw.lang.ir.IJavaClassIRType;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.IRType;
import gw.lang.ir.IRTypeConstants;
import gw.lang.ir.builder.IRArgConverter;
import gw.lang.ir.builder.IRBuilderContext;
import gw.lang.ir.builder.IRExpressionBuilder;
import gw.lang.ir.expression.IRIdentifier;
import gw.lang.ir.expression.IRMethodCallExpression;
import gw.lang.ir.statement.IRMethodStatement;
import gw.lang.reflect.java.IJavaClassConstructor;
import gw.lang.reflect.java.IJavaClassMethod;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

@UnstableAPI
public class IRMethodCallExpressionBuilder
extends IRExpressionBuilder {
    private BuilderImpl _builderImpl;

    public static IRMethodCallExpressionBuilder callSuperInit(List<IRExpressionBuilder> args) {
        return new IRMethodCallExpressionBuilder(new SuperInitBuilder(args));
    }

    private IRMethodCallExpressionBuilder(BuilderImpl builderImpl) {
        this._builderImpl = builderImpl;
    }

    public IRMethodCallExpressionBuilder(IRExpressionBuilder root, String name, List<IRExpressionBuilder> args) {
        this._builderImpl = new RootAndNameAndArgsBuilder(root, name, args);
    }

    public IRMethodCallExpressionBuilder(IRExpressionBuilder root, IJavaClassMethod method, List<IRExpressionBuilder> args) {
        this._builderImpl = new MethodAndArgsBuilder(root, method, args);
    }

    public IRMethodCallExpressionBuilder(IRExpressionBuilder root, Method method, List<IRExpressionBuilder> args) {
        this._builderImpl = new JavaMethodAndArgsBuilder(root, method, args);
    }

    @Override
    protected IRExpression buildImpl(IRBuilderContext context) {
        return this._builderImpl.buildImpl(context);
    }

    private static IRMethodCallExpression buildCall(IRBuilderContext context, String name, IRExpression root, List<IRExpressionBuilder> argBuilders, MethodInfo methodInfo) {
        List<IRType> parameterTypes = methodInfo.getParamTypes();
        ArrayList<IRExpression> args = new ArrayList<IRExpression>();
        for (int i = 0; i < argBuilders.size(); ++i) {
            args.add(IRArgConverter.castOrConvertIfNecessary(parameterTypes.get(i), argBuilders.get(i).build(context)));
        }
        IRMethodCallExpression methodCall = new IRMethodCallExpression(name, methodInfo.getOwningType(), methodInfo.isInterface(), methodInfo.getReturnType(), parameterTypes, root, args);
        methodCall.setSpecial(methodInfo.isSpecial());
        return methodCall;
    }

    private static MethodInfo findMethod(String name, int numArgs, IRType rootType, IRBuilderContext context) {
        if (rootType instanceof IJavaClassIRType) {
            IJavaClassMethod method = IRMethodCallExpressionBuilder.findMethod(((IJavaClassIRType)rootType).getJavaClassInfo(), name, numArgs);
            return new MethodInfo(method);
        }
        if (rootType.equals(context.owningType())) {
            IRMethodStatement methodDecl = context.findMethod(name, numArgs);
            if (methodDecl != null) {
                ArrayList<IRType> paramTypes = new ArrayList<IRType>();
                for (IRSymbol paramSymbol : methodDecl.getParameters()) {
                    paramTypes.add(paramSymbol.getType());
                }
                return new MethodInfo(context.owningType(), paramTypes, methodDecl.getReturnType(), false);
            }
            return IRMethodCallExpressionBuilder.findMethod(name, numArgs, context.currentClassSuperType(), context);
        }
        throw new IllegalArgumentException("Cannot reference a method only by name on a root expression that's not an IJavaClassIRType");
    }

    private static class MethodInfo {
        private IRType _owningType;
        private List<IRType> _paramTypes;
        private IRType _returnType;
        private boolean _special;

        private MethodInfo(IJavaClassMethod method) {
            this(IRMethodCallExpressionBuilder.getIRType(method.getEnclosingClass()), IRMethodCallExpressionBuilder.getIRTypes(method.getParameterTypes()), IRMethodCallExpressionBuilder.getIRType(method.getReturnClassInfo()), false);
        }

        private MethodInfo(Method method) {
            this(IRMethodCallExpressionBuilder.getIRType(method.getDeclaringClass()), IRMethodCallExpressionBuilder.getIRTypes(method.getParameterTypes()), IRMethodCallExpressionBuilder.getIRType(method.getReturnType()), false);
        }

        private MethodInfo(IRType owningType, List<IRType> paramTypes, IRType returnType, boolean special) {
            this._owningType = owningType;
            this._paramTypes = paramTypes;
            this._returnType = returnType;
            this._special = special;
        }

        public IRType getOwningType() {
            return this._owningType;
        }

        public List<IRType> getParamTypes() {
            return this._paramTypes;
        }

        public IRType getReturnType() {
            return this._returnType;
        }

        public boolean isInterface() {
            return this._owningType.isInterface();
        }

        public boolean isSpecial() {
            return this._special;
        }
    }

    private static final class SuperInitBuilder
    implements BuilderImpl {
        private List<IRExpressionBuilder> _args;

        private SuperInitBuilder(List<IRExpressionBuilder> args) {
            this._args = args;
        }

        @Override
        public IRMethodCallExpression buildImpl(IRBuilderContext context) {
            IRType type = context.currentClassSuperType();
            if (type instanceof IJavaClassIRType) {
                IJavaClassConstructor cons = IRMethodCallExpressionBuilder.findConstructor(((IJavaClassIRType)type).getJavaClassInfo(), this._args.size());
                MethodInfo methodInfo = new MethodInfo(type, IRMethodCallExpressionBuilder.getIRTypes(cons.getParameterTypes()), IRTypeConstants.pVOID(), true);
                return IRMethodCallExpressionBuilder.buildCall(context, "<init>", new IRIdentifier(new IRSymbol("this", context.owningType(), false)), this._args, methodInfo);
            }
            throw new IllegalArgumentException();
        }
    }

    private static final class JavaMethodAndArgsBuilder
    implements BuilderImpl {
        private IRExpressionBuilder _root;
        private Method _method;
        private List<IRExpressionBuilder> _args;

        private JavaMethodAndArgsBuilder(IRExpressionBuilder root, Method method, List<IRExpressionBuilder> args) {
            this._root = root;
            this._method = method;
            this._args = args;
        }

        @Override
        public IRMethodCallExpression buildImpl(IRBuilderContext context) {
            IRExpression root = this._root == null ? null : this._root.build(context);
            MethodInfo methodInfo = new MethodInfo(this._method);
            return IRMethodCallExpressionBuilder.buildCall(context, this._method.getName(), root, this._args, methodInfo);
        }
    }

    private static final class MethodAndArgsBuilder
    implements BuilderImpl {
        private IRExpressionBuilder _root;
        private IJavaClassMethod _method;
        private List<IRExpressionBuilder> _args;

        private MethodAndArgsBuilder(IRExpressionBuilder root, IJavaClassMethod method, List<IRExpressionBuilder> args) {
            this._root = root;
            this._method = method;
            this._args = args;
        }

        @Override
        public IRMethodCallExpression buildImpl(IRBuilderContext context) {
            IRExpression root = this._root == null ? null : this._root.build(context);
            MethodInfo methodInfo = new MethodInfo(this._method);
            return IRMethodCallExpressionBuilder.buildCall(context, this._method.getName(), root, this._args, methodInfo);
        }
    }

    private static final class RootAndNameAndArgsBuilder
    implements BuilderImpl {
        private IRExpressionBuilder _root;
        private String _name;
        private List<IRExpressionBuilder> _args;

        private RootAndNameAndArgsBuilder(IRExpressionBuilder root, String name, List<IRExpressionBuilder> args) {
            this._root = root;
            this._name = name;
            this._args = args;
        }

        @Override
        public IRMethodCallExpression buildImpl(IRBuilderContext context) {
            IRExpression root = this._root.build(context);
            IRType rootType = root.getType();
            MethodInfo methodInfo = IRMethodCallExpressionBuilder.findMethod(this._name, this._args.size(), rootType, context);
            return IRMethodCallExpressionBuilder.buildCall(context, this._name, root, this._args, methodInfo);
        }
    }

    private static interface BuilderImpl {
        public IRMethodCallExpression buildImpl(IRBuilderContext var1);
    }
}

