/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.ir.expression;

import gw.config.CommonServices;
import gw.lang.UnstableAPI;
import gw.lang.ir.IRElement;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRType;
import gw.lang.reflect.java.JavaTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@UnstableAPI
public class IRCompositeExpression
extends IRExpression {
    private List<IRElement> _elements;

    public IRCompositeExpression(IRElement ... elements) {
        this._elements = new ArrayList<IRElement>(Arrays.asList(elements));
        for (IRElement element : this._elements) {
            element.setParent(this);
        }
    }

    public IRCompositeExpression(List<IRElement> elements) {
        this._elements = elements;
        for (IRElement element : this._elements) {
            element.setParent(this);
        }
    }

    public List<IRElement> getElements() {
        return this._elements;
    }

    public void addElement(IRElement element) {
        this._elements.add(element);
        element.setParent(this);
    }

    @Override
    public IRType getType() {
        IRElement irElement = this._elements.get(this._elements.size() - 1);
        if (irElement instanceof IRExpression) {
            IRExpression expr = (IRExpression)irElement;
            return expr.getType();
        }
        return CommonServices.getGosuIndustrialPark().getIRTypeResolver().getDescriptor(JavaTypes.pVOID());
    }
}

