/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.parser;

import gw.util.StreamUtil;
import java.io.IOException;
import java.io.Reader;

public class SourceCodeReader {
    private CharSequence _source;
    private int _iLength;
    private int _iPosition;

    public SourceCodeReader(CharSequence source) {
        this._source = source;
        this._iLength = this._source == null ? -1 : this._source.length();
        this._iPosition = 0;
    }

    public int read() throws IOException {
        return this._iLength > this._iPosition ? (int)this._source.charAt(this._iPosition++) : -1;
    }

    public int peek() {
        return this._iLength > this._iPosition ? (int)this._source.charAt(this._iPosition) : -1;
    }

    public int getPosition() {
        return this._iPosition;
    }

    public void setPosition(int iPosition) throws IOException {
        if (iPosition < 0) {
            throw new IOException(iPosition + " < 0");
        }
        this._iPosition = iPosition;
    }

    public String getSource() {
        return this._source.toString();
    }

    public CharSequence subsequence(int iStart, int iEnd) {
        return this._source.subSequence(iStart, iEnd);
    }

    public static SourceCodeReader makeSourceCodeReader(Reader reader) {
        try {
            return new SourceCodeReader(StreamUtil.getContent(reader));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getLength() {
        return this._iLength;
    }
}

