/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.parser;

import gw.lang.GosuShop;
import gw.lang.parser.IActivationContext;
import gw.lang.parser.IScope;
import gw.lang.parser.ISymbol;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.StandardScope;
import gw.util.GosuObjectUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class StandardSymbolTable
implements ISymbolTable {
    public static final Method PRINT;
    private ArrayList _stackScopes;
    private LinkedList _stackPrivateGlobalScopes;
    private int[] _scopeSizes;
    private int _iScopeCsr;

    public StandardSymbolTable() {
        this.init();
        this.pushScope();
    }

    public StandardSymbolTable(boolean bDefineCommonSymbols) {
        this.init();
        if (bDefineCommonSymbols) {
            this.defineCommonSymbols();
        }
        this.pushScope();
    }

    private void init() {
        this._stackScopes = new ArrayList();
        this._stackPrivateGlobalScopes = new LinkedList();
        this._scopeSizes = new int[8];
        this._iScopeCsr = 0;
    }

    private StandardSymbolTable(StandardSymbolTable source) {
        IScope scope;
        Object obj;
        int i;
        this._stackScopes = new ArrayList(source._stackScopes);
        for (i = 0; i < this._stackScopes.size(); ++i) {
            obj = this._stackScopes.get(i);
            scope = (IScope)obj;
            this._stackScopes.set(i, scope.copy());
        }
        this._stackPrivateGlobalScopes = new LinkedList(source._stackPrivateGlobalScopes);
        for (i = 0; i < this._stackPrivateGlobalScopes.size(); ++i) {
            obj = this._stackPrivateGlobalScopes.get(i);
            scope = (IScope)obj;
            this._stackPrivateGlobalScopes.set(i, scope.copy());
        }
        this._scopeSizes = new int[source._scopeSizes.length];
        System.arraycopy(source._scopeSizes, 0, this._scopeSizes, 0, this._scopeSizes.length);
    }

    @Override
    public ISymbol getSymbol(CharSequence name) {
        return this.getSymbol(name, this._stackScopes.size() - 1);
    }

    @Override
    public void putSymbol(ISymbol symbol) {
        String name = symbol.getName();
        this.peekScope().put(name, symbol);
        symbol.setDynamicSymbolTable(this);
    }

    @Override
    public ISymbol removeSymbol(CharSequence name) {
        for (int i = this._stackScopes.size() - 1; i >= 0; --i) {
            IScope scope = (IScope)this._stackScopes.get(i);
            Object symbol = scope.get(name);
            if (symbol == null) continue;
            return (ISymbol)scope.remove(name);
        }
        return null;
    }

    @Override
    public int getTotalSymbolCount() {
        IActivationContext activationCtx;
        IScope scope;
        int i;
        int count = 0;
        int iActivationScopeIndex = -1;
        for (i = this._stackScopes.size() - 1; i >= 0; --i) {
            scope = (IScope)this._stackScopes.get(i);
            count += scope.countSymbols();
            activationCtx = scope.getActivationCtx();
            if (activationCtx == null || activationCtx.isTransparent()) continue;
            iActivationScopeIndex = i;
            break;
        }
        if (iActivationScopeIndex != -1) {
            if (this._stackPrivateGlobalScopes.size() > 0) {
                IScope scope2 = (IScope)this._stackPrivateGlobalScopes.getFirst();
                count += scope2.countSymbols();
            }
            for (i = 0; i < this._stackScopes.size() && ((activationCtx = (scope = (IScope)this._stackScopes.get(i)).getActivationCtx()) == null || activationCtx.isTransparent()); ++i) {
                count += scope.countSymbols();
            }
        }
        return count;
    }

    @Override
    public Map getSymbols() {
        return this.getSymbols(this._stackScopes.size() - 1, -1);
    }

    @Override
    public Map getSymbols(int iStartIndex, int iPrivateGlobalIndex) {
        HashMap symbols = new HashMap();
        this.getSymbols(symbols, iStartIndex, iPrivateGlobalIndex);
        return symbols;
    }

    @Override
    public int getScopeCount() {
        return this._stackScopes.size();
    }

    @Override
    public int getPrivateGlobalScopeCount() {
        return this._stackPrivateGlobalScopes.size();
    }

    @Override
    public IScope pushScope() {
        return this.addScope(this.createScope(null));
    }

    @Override
    public IScope pushScope(IScope scope) {
        return this.addScope(scope);
    }

    @Override
    public void pushPrivateGlobalScope(IScope scope) {
        this._stackPrivateGlobalScopes.addLast(scope);
    }

    @Override
    public void popGlobalScope(IScope scope) {
        if (this._stackPrivateGlobalScopes.getLast() == scope) {
            this._stackPrivateGlobalScopes.removeLast();
            return;
        }
        this.removeGlobalScope(scope);
    }

    @Override
    public IScope pushIsolatedScope(IActivationContext activationCtx) {
        if (activationCtx == null) {
            throw new IllegalArgumentException("The activation context must be non-null");
        }
        return this.addScope(this.createScope(activationCtx));
    }

    @Override
    public IScope popScope() {
        IScope scope = (IScope)this._stackScopes.remove(this._stackScopes.size() - 1);
        if (scope.getActivationCtx() != null) {
            this._scopeSizes[this._iScopeCsr] = 0;
            --this._iScopeCsr;
        }
        return scope;
    }

    @Override
    public IScope popScope(IScope scope) {
        while (!this._stackScopes.isEmpty() && scope != this.popScope()) {
        }
        return scope;
    }

    @Override
    public ISymbolTable copy() {
        return new StandardSymbolTable(this);
    }

    @Override
    public ISymbol getThisSymbolFromStackOrMap() {
        return this.getSymbol(ISymbol.THIS);
    }

    @Override
    public void defineCommonSymbols() {
        this.pushScope(GosuShop.createCommonSymbolScope());
    }

    @Override
    public boolean isSymbolWithinScope(ISymbol symToFind, IScope containingScope) {
        for (int i = this._stackScopes.size() - 1; i >= 0; --i) {
            IScope scope = (IScope)this._stackScopes.get(i);
            Collection collection = scope.values();
            for (Object symbol : collection) {
                if (!GosuObjectUtil.equals(symToFind, symbol)) continue;
                return true;
            }
            if (scope == containingScope) break;
        }
        return false;
    }

    @Override
    public IScope peekIsolatedScope() {
        for (int i = this._stackScopes.size() - 1; i > 0; --i) {
            IScope iScope = (IScope)this._stackScopes.get(i);
            if (iScope.getActivationCtx() == null || iScope.getActivationCtx().isTransparent()) continue;
            return iScope;
        }
        return null;
    }

    @Override
    public int getNextStackIndex() {
        this.ensureIsolatedScopeSizesCapacity();
        int csr = this._iScopeCsr;
        return this.getNextStackIndexForScopeIndex(csr);
    }

    @Override
    public int getNextStackIndexForScope(IScope scope) {
        this.ensureIsolatedScopeSizesCapacity();
        int csr = scope.getCSR();
        return this.getNextStackIndexForScopeIndex(csr);
    }

    private int getNextStackIndexForScopeIndex(int csr) {
        if (this._scopeSizes[csr] == 0) {
            this._scopeSizes[csr] = 2;
        }
        int n = csr;
        int n2 = this._scopeSizes[n];
        this._scopeSizes[n] = n2 + 1;
        return n2;
    }

    @Override
    public boolean hasIsolatedScope() {
        return this._iScopeCsr > 0;
    }

    private ISymbol getSymbol(CharSequence strName, int iStartIndex) {
        for (int i = iStartIndex; i >= 0; --i) {
            Object obj = this._stackScopes.get(i);
            IScope scope = (IScope)obj;
            Object symbol = scope.get(strName);
            if (symbol != null) {
                return (ISymbol)symbol;
            }
            IActivationContext activationCtx = scope.getActivationCtx();
            if (activationCtx == null || activationCtx.isTransparent()) continue;
            return this.getGlobalSymbol(strName);
        }
        return null;
    }

    private ISymbol getGlobalSymbol(CharSequence strName) {
        int iSize = this._stackScopes.size();
        for (int i = 0; i < iSize; ++i) {
            Object obj = this._stackScopes.get(i);
            IScope scope = (IScope)obj;
            IActivationContext activationCtx = scope.getActivationCtx();
            if (activationCtx == null || activationCtx.isTransparent()) continue;
            ISymbol privateGlobal = this.getPrivateGlobalSymbol(strName);
            if (privateGlobal != null) {
                return privateGlobal;
            }
            int iGlobalFloor = i - 1;
            if (iGlobalFloor >= 0) {
                return this.getSymbol(strName, iGlobalFloor);
            }
            return null;
        }
        return null;
    }

    private ISymbol getPrivateGlobalSymbol(CharSequence strName) {
        if (this._stackPrivateGlobalScopes.isEmpty()) {
            return null;
        }
        IScope scope = (IScope)this._stackPrivateGlobalScopes.getLast();
        return (ISymbol)scope.get(strName);
    }

    private IScope addScope(IScope scope) {
        this._stackScopes.add(scope);
        if (scope.getActivationCtx() != null) {
            ++this._iScopeCsr;
            scope.setCSR(this._iScopeCsr);
        }
        return scope;
    }

    private IScope createScope(IActivationContext activationCtx) {
        return new StandardScope(activationCtx, 8);
    }

    private void removeGlobalScope(IScope globalScope) {
        int iIndex = this.getIndexOfGlobalScope(globalScope);
        this._stackScopes.remove(iIndex - 1);
    }

    private int getIndexOfGlobalScope(IScope globalScope) {
        int iIndex = this.getInsertionIndexOfGlobalScope();
        IScope scope = (IScope)this._stackScopes.get(iIndex - 1);
        if (scope != globalScope) {
            throw new IllegalArgumentException("Cannot remove the specified global scope because it is different than the global scope currently occupying the top of the global scope stack.");
        }
        return iIndex;
    }

    private int getInsertionIndexOfGlobalScope() {
        Object obj;
        IScope scope;
        IActivationContext activationCtx;
        int i;
        int iSize = this._stackScopes.size();
        for (i = 0; i < iSize && ((activationCtx = (scope = (IScope)(obj = this._stackScopes.get(i))).getActivationCtx()) == null || activationCtx.isTransparent()); ++i) {
        }
        return i;
    }

    private void getSymbols(Map symbols, int iStartIndex, int iPrivateGlobalIndex) {
        if (iStartIndex < 0) {
            iStartIndex = this._stackScopes.size() - 1;
        }
        for (int i = iStartIndex; i >= 0; --i) {
            Object obj = this._stackScopes.get(i);
            IScope scope = (IScope)obj;
            symbols.putAll(scope);
            IActivationContext activationCtx = scope.getActivationCtx();
            if (activationCtx == null || activationCtx.isTransparent()) continue;
            this.getGlobalSymbols(symbols, iPrivateGlobalIndex);
            return;
        }
    }

    private void getGlobalSymbols(Map symbols, int iPrivateGlobalIndex) {
        int iSize = this._stackScopes.size();
        for (int i = 0; i < iSize; ++i) {
            Object obj = this._stackScopes.get(i);
            IScope scope = (IScope)obj;
            IActivationContext activationCtx = scope.getActivationCtx();
            if (activationCtx == null || activationCtx.isTransparent()) continue;
            this.getPrivateGlobalSymbols(symbols, iPrivateGlobalIndex);
            int iGlobalFloor = i - 1;
            if (iGlobalFloor >= 0) {
                this.getSymbols(symbols, iGlobalFloor, iPrivateGlobalIndex);
            }
            return;
        }
    }

    private void getPrivateGlobalSymbols(Map symbols, int iPrivateGlobalIndex) {
        if (this._stackPrivateGlobalScopes.isEmpty()) {
            return;
        }
        if (iPrivateGlobalIndex < 0) {
            return;
        }
        IScope scope = (IScope)this._stackPrivateGlobalScopes.get(iPrivateGlobalIndex);
        symbols.putAll(scope);
    }

    @Override
    public IScope peekScope() {
        return (IScope)this._stackScopes.get(this._stackScopes.size() - 1);
    }

    @Override
    public IScope peekScope(int iPos) {
        return (IScope)this._stackScopes.get(this._stackScopes.size() - (1 + iPos));
    }

    private void ensureIsolatedScopeSizesCapacity() {
        if (this._iScopeCsr < this._scopeSizes.length) {
            return;
        }
        int[] oldStack = this._scopeSizes;
        int iNewSize = this._iScopeCsr * 3 / 2 + 1;
        this._scopeSizes = new int[iNewSize];
        System.arraycopy(oldStack, 0, this._scopeSizes, 0, oldStack.length);
    }

    public String toString() {
        String text = "symbols: ";
        Map symbols = this.getSymbols();
        for (Object name : symbols.keySet()) {
            text = text + name + ", ";
        }
        return text;
    }

    static {
        try {
            PRINT = GosuShop.class.getMethod("print", Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

