/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.lang.Returns;
import gw.lang.reflect.IAnnotatedFeatureInfo;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IAttributedFeatureInfo;
import gw.lang.reflect.IExceptionInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuClassTypeInfo;
import gw.lang.reflect.gs.IGosuConstructorInfo;
import gw.lang.reflect.gs.IGosuMethodInfo;
import gw.lang.reflect.gs.IGosuMethodParamInfo;
import gw.lang.reflect.gs.IGosuPropertyInfo;
import gw.lang.reflect.java.JavaTypes;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class AnnotationReflectUtil {
    public static String evalDeprecationReason(IAnnotatedFeatureInfo featureInfo) {
        if (AnnotationReflectUtil.isGosuFeature(featureInfo)) {
            String deprecatedReason = "";
            List<IAnnotationInfo> annotation = featureInfo.getAnnotationsOfType(JavaTypes.GW_LANG_DEPRECATED());
            if (annotation.size() > 0) {
                try {
                    IAnnotationInfo annotationInfo = annotation.get(0);
                    if (annotationInfo != null) {
                        deprecatedReason = (String)annotationInfo.getFieldValue("value");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return deprecatedReason;
        }
        return featureInfo.getDeprecatedReason();
    }

    public static List<IExceptionInfo> evalThrowsInfos(IAnnotatedFeatureInfo typeInfo) {
        ArrayList<IExceptionInfo> lst = new ArrayList<IExceptionInfo>();
        for (IAnnotationInfo aThrows : AnnotationReflectUtil.evalThrows(typeInfo)) {
            lst.add(new SyntheticExceptionInfo(typeInfo, ((IType)aThrows.getFieldValue("ExceptionType")).getName(), (String)aThrows.getFieldValue("ExceptionDescription")));
        }
        return lst;
    }

    private static List<IAnnotationInfo> evalThrows(IAnnotatedFeatureInfo typeInfo) {
        ArrayList<IAnnotationInfo> throwsLst = new ArrayList<IAnnotationInfo>();
        try {
            for (IAnnotationInfo annotationInfo : typeInfo.getAnnotationsOfType(JavaTypes.THROWS())) {
                throwsLst.add(annotationInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return throwsLst;
    }

    public static String evalReturnDescription(IMethodInfo method) {
        if (method instanceof IGosuMethodInfo) {
            List<IAnnotationInfo> annotation = method.getAnnotationsOfType(JavaTypes.getGosuType(Returns.class));
            if (annotation.size() > 0) {
                return (String)annotation.get(0).getFieldValue("value");
            }
        } else {
            return method.getReturnDescription();
        }
        return "";
    }

    public static boolean evalVisibleForWebservice(IMethodInfo method) {
        return !AnnotationReflectUtil.evalIsHidden(method);
    }

    public static boolean evalIsHidden(IAnnotatedFeatureInfo featureInfo) {
        return !featureInfo.getAnnotationsOfType(JavaTypes.INTERNAL_API()).isEmpty();
    }

    public static String evalParameterDecription(IParameterInfo parameterData) {
        if (parameterData instanceof IGosuMethodParamInfo) {
            IFeatureInfo featureInfo = parameterData.getContainer();
            IAttributedFeatureInfo annotatedFI = (IAttributedFeatureInfo)featureInfo;
            List<IAnnotationInfo> annotation = annotatedFI.getAnnotationsOfType(JavaTypes.PARAM());
            for (IAnnotationInfo o : annotation) {
                if (o == null || !o.getFieldValue("FieldName").equals(parameterData.getName())) continue;
                return (String)o.getFieldValue("FieldDescription");
            }
            return "";
        }
        return parameterData.getDescription();
    }

    private static boolean isGosuFeature(IAnnotatedFeatureInfo featureInfo) {
        return featureInfo instanceof IGosuMethodInfo || featureInfo instanceof IGosuPropertyInfo || featureInfo instanceof IGosuConstructorInfo || featureInfo instanceof IGosuClassTypeInfo;
    }

    public static class SyntheticExceptionInfo
    implements IExceptionInfo {
        private IFeatureInfo _container;
        private String _exceptionName;
        private String _exceptionDescription;

        public SyntheticExceptionInfo(IFeatureInfo container, String exceptionName, String exceptionDescription) {
            this._container = container;
            this._exceptionName = exceptionName;
            this._exceptionDescription = exceptionDescription;
        }

        @Override
        public IFeatureInfo getContainer() {
            return this._container;
        }

        @Override
        public IType getOwnersType() {
            return this._container.getOwnersType();
        }

        @Override
        public String getName() {
            return this._exceptionName;
        }

        @Override
        public String getDisplayName() {
            return this._exceptionName;
        }

        @Override
        public String getDescription() {
            return this._exceptionDescription;
        }

        @Override
        public IType getExceptionType() {
            return TypeSystem.getByFullNameIfValid(this.getName());
        }
    }
}

