/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.lang.reflect.BaseFeatureInfo;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.TypeSystem;
import java.util.Collections;
import java.util.List;

public abstract class BaseJavaTypeInfo
extends BaseFeatureInfo
implements ITypeInfo {
    public BaseJavaTypeInfo(Class javaClass) {
        super(TypeSystem.getByFullName(javaClass.getName()));
    }

    @Override
    public String getName() {
        return this.getOwnersType().getRelativeName();
    }

    @Override
    public List<IAnnotationInfo> getDeclaredAnnotations() {
        return Collections.emptyList();
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    public String getShortDescription() {
        return this.getName();
    }

    @Override
    public String getDescription() {
        return this.getName();
    }

    @Override
    public boolean isStatic() {
        return true;
    }

    @Override
    public IMethodInfo getMethod(CharSequence methodName, IType ... params) {
        return ITypeInfo.FIND.method(this.getMethods(), methodName, params);
    }

    @Override
    public IConstructorInfo getConstructor(IType ... params) {
        return ITypeInfo.FIND.constructor(this.getConstructors(), params);
    }

    @Override
    public IMethodInfo getCallableMethod(CharSequence strMethod, IType ... params) {
        return ITypeInfo.FIND.callableMethod(this.getMethods(), strMethod, params);
    }

    @Override
    public IConstructorInfo getCallableConstructor(IType ... params) {
        return ITypeInfo.FIND.callableConstructor(this.getConstructors(), params);
    }
}

