/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.lang.function.IBlock;
import gw.lang.reflect.IExpando;
import gw.lang.reflect.IPlaceholder;
import gw.util.GosuEscapeUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Expando
implements IExpando {
    private Map<String, Object> _map = new LinkedHashMap<String, Object>();

    @Override
    public Object getFieldValue(String field) {
        return this._map.get(field);
    }

    @Override
    public void setFieldValue(String field, Object value) {
        this._map.put(field, value);
    }

    @Override
    public Object invoke(String methodName, Object ... args) {
        Object f = this._map.get(methodName);
        if (f instanceof IBlock) {
            return ((IBlock)f).invokeWithArgs(args);
        }
        return IPlaceholder.UNHANDLED;
    }

    @Override
    public void setDefaultFieldValue(String name) {
        this.setFieldValue(name, new Expando());
    }

    @Override
    public Map getMap() {
        return this._map;
    }

    public String toGosu() {
        StringBuilder sb = new StringBuilder();
        this.toGosu(true, sb, 0);
        return sb.toString();
    }

    public void toGosu(boolean bWithDynamic, StringBuilder sb, int indent) {
        int iKey = 0;
        this.indent(sb, indent);
        sb.append("new").append(bWithDynamic ? " dynamic.Dynamic()" : "()");
        if (this._map.size() > 0) {
            sb.append(" {\n");
            for (String key : this._map.keySet()) {
                this.indent(sb, indent + 2);
                sb.append(":").append(key).append(" = ");
                Object value = this._map.get(key);
                if (value instanceof Expando) {
                    ((Expando)value).toGosu(false, sb, indent + 2);
                } else if (value instanceof List) {
                    int length = ((List)value).size();
                    sb.append('{');
                    if (length > 0) {
                        sb.append("\n");
                        int iSize = ((List)value).size();
                        for (int i = 0; i < iSize; ++i) {
                            Object comp = ((List)value).get(i);
                            if (comp instanceof Expando) {
                                ((Expando)comp).toGosu(false, sb, indent + 4);
                            } else {
                                this.indent(sb, indent + 4);
                                this.appendGosuValue(sb, comp);
                            }
                            this.appendCommaNewLine(sb, i < iSize - 1);
                        }
                    }
                    this.indent(sb, indent + 2);
                    sb.append("}");
                } else {
                    this.appendGosuValue(sb, value);
                }
                this.appendCommaNewLine(sb, iKey++ < this._map.size() - 1);
            }
        }
        this.indent(sb, indent);
        sb.append("}");
    }

    private void appendCommaNewLine(StringBuilder sb, boolean bComma) {
        if (bComma) {
            sb.append(',');
        }
        sb.append("\n");
    }

    private StringBuilder appendGosuValue(StringBuilder sb, Object comp) {
        if (comp instanceof String) {
            sb.append('\"');
            sb.append(GosuEscapeUtil.escapeForGosuStringLiteral((String)comp));
            sb.append('\"');
        } else if (comp instanceof Integer || comp instanceof Long || comp instanceof Double || comp instanceof Float || comp instanceof Short || comp instanceof Character || comp instanceof Byte) {
            sb.append(comp);
        } else if (comp == null) {
            sb.append("null");
        } else {
            throw new IllegalStateException("Unsupported expando type: " + comp.getClass());
        }
        return sb;
    }

    public String toXml(String name) {
        StringBuilder sb = new StringBuilder();
        this.toXml(name, sb, 0);
        return sb.toString();
    }

    public void toXml(String name, StringBuilder sb, int indent) {
        this.indent(sb, indent);
        sb.append('<').append(name);
        if (this._map.size() > 0) {
            sb.append(">\n");
            for (String key : this._map.keySet()) {
                Object value = this._map.get(key);
                if (value instanceof Expando) {
                    ((Expando)value).toXml(key, sb, indent + 2);
                    continue;
                }
                if (value instanceof List) {
                    int length = ((List)value).size();
                    this.indent(sb, indent + 2);
                    sb.append("<").append(key);
                    if (length > 0) {
                        sb.append(">\n");
                        for (Object comp : (List)value) {
                            if (comp instanceof Expando) {
                                ((Expando)comp).toXml("li", sb, indent + 4);
                                continue;
                            }
                            this.indent(sb, indent + 4);
                            sb.append("<li>").append(comp).append("</li>\n");
                        }
                        this.indent(sb, indent + 2);
                        sb.append("</").append(key).append(">\n");
                        continue;
                    }
                    sb.append("/>\n");
                    continue;
                }
                this.indent(sb, indent + 2);
                sb.append('<').append(key).append(">");
                sb.append(value);
                sb.append("</").append(key).append(">\n");
            }
            this.indent(sb, indent);
            sb.append("</").append(name).append(">\n");
        } else {
            sb.append("/>\n");
        }
    }

    private void indent(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Expando)) {
            return false;
        }
        Expando expando = (Expando)o;
        return this._map.equals(expando._map);
    }

    public int hashCode() {
        return this._map.hashCode();
    }

    public String toString() {
        return "Expando{_map=" + this._map + '}';
    }
}

