/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.lang.reflect.IAttributedFeatureInfo;

public class Modifier
extends java.lang.reflect.Modifier {
    public static final int OVERRIDE = 65536;
    public static final int HIDE = 0x2000000;
    public static final int CLASS_MEMBER = 262144;
    public static final int INTERNAL = 524288;
    public static final int ENUM = 16384;
    public static final int DEPRECATED = 131072;
    public static final int ANNOTATION = 8192;

    public static int getModifiersFrom(IAttributedFeatureInfo afi) {
        int iModifiers = 0;
        iModifiers = Modifier.setBit(iModifiers, afi.isPublic(), 1);
        iModifiers = Modifier.setBit(iModifiers, afi.isPrivate(), 2);
        iModifiers = Modifier.setBit(iModifiers, afi.isProtected(), 4);
        iModifiers = Modifier.setBit(iModifiers, afi.isInternal(), 524288);
        iModifiers = Modifier.setBit(iModifiers, afi.isStatic(), 8);
        return iModifiers;
    }

    public static boolean isHide(int mod) {
        return (mod & 0x2000000) != 0;
    }

    public static boolean isOverride(int mod) {
        return (mod & 0x10000) != 0;
    }

    public static boolean isClassMember(int mod) {
        return (mod & 0x40000) != 0;
    }

    public static boolean isInternal(int mod) {
        return (mod & 0x80000) != 0;
    }

    public static boolean isEnum(int mod) {
        return (mod & 0x4000) != 0;
    }

    public static boolean isDeprecated(int mod) {
        return (mod & 0x20000) != 0;
    }

    public static boolean isAnnotation(int mod) {
        return (mod & 0x2000) != 0;
    }

    public static int setPublic(int mod, boolean bValue) {
        return Modifier.setBit(mod, bValue, 1);
    }

    public static int setPrivate(int mod, boolean bValue) {
        return Modifier.setBit(mod, bValue, 2);
    }

    public static int setProtected(int mod, boolean bValue) {
        return Modifier.setBit(mod, bValue, 4);
    }

    public static int setStatic(int mod, boolean bValue) {
        return Modifier.setBit(mod, bValue, 8);
    }

    public static int setAbstract(int mod, boolean bValue) {
        return Modifier.setBit(mod, bValue, 1024);
    }

    public static int setFinal(int mod, boolean bValue) {
        return Modifier.setBit(mod, bValue, 16);
    }

    public static int setOverride(int mod, boolean bValue) {
        return Modifier.setBit(mod, bValue, 65536);
    }

    public static int setHide(int mod, boolean bValue) {
        return Modifier.setBit(mod, bValue, 0x2000000);
    }

    public static int setClassMember(int mod, boolean bValue) {
        return Modifier.setBit(mod, bValue, 262144);
    }

    public static int setTransient(int mod, boolean bValue) {
        return Modifier.setBit(mod, bValue, 128);
    }

    public static int setInternal(int mod, boolean bValue) {
        return Modifier.setBit(mod, bValue, 524288);
    }

    public static int setEnum(int mod, boolean bValue) {
        return Modifier.setBit(mod, bValue, 16384);
    }

    public static int setDeprecated(int mod, boolean bValue) {
        return Modifier.setBit(mod, bValue, 131072);
    }

    private static int setBit(int mod, boolean bValue, int bit) {
        if (bValue) {
            return mod |= bit;
        }
        return mod &= ~bit;
    }

    public static String toModifierString(int mod) {
        int len;
        StringBuffer sb = new StringBuffer();
        if ((mod & 1) != 0) {
            sb.append("public ");
        }
        if ((mod & 4) != 0) {
            sb.append("protected ");
        }
        if ((mod & 2) != 0) {
            sb.append("private ");
        }
        if ((mod & 0x400) != 0) {
            sb.append("abstract ");
        }
        if ((mod & 8) != 0) {
            sb.append("static ");
        }
        if ((mod & 0x10) != 0) {
            sb.append("final ");
        }
        if ((mod & 0x80) != 0) {
            sb.append("transient ");
        }
        if ((mod & 0x40) != 0) {
            sb.append("volatile ");
        }
        if ((mod & 0x20) != 0) {
            sb.append("synchronized ");
        }
        if ((mod & 0x100) != 0) {
            sb.append("native ");
        }
        if ((mod & 0x800) != 0) {
            sb.append("strictfp ");
        }
        if ((len = sb.length()) > 0) {
            return sb.toString().substring(0, len - 1);
        }
        return "";
    }
}

