/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.features;

import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.features.FeatureReference;
import gw.lang.reflect.features.IPropertyReference;
import gw.lang.reflect.features.PropertyReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BoundPropertyReference<R, T>
extends FeatureReference<R, T>
implements IPropertyReference<R, T> {
    private IPropertyInfo _pi;
    private IType _rootType;
    private Object _ctx;

    public BoundPropertyReference(IType rootType, Object ctx, String property) {
        this._rootType = rootType;
        this._ctx = ctx;
        this._pi = PropertyReference.getPropertyInfo(rootType, property);
    }

    public T get() {
        return (T)this._pi.getAccessor().getValue(this._ctx);
    }

    public void set(T val) {
        this._pi.getAccessor().setValue(this._ctx, val);
    }

    @Override
    public IType getRootType() {
        return this._rootType;
    }

    public Object getCtx() {
        return this._ctx;
    }

    @Override
    public IPropertyInfo getPropertyInfo() {
        return this._pi;
    }

    @Override
    public IFeatureInfo getFeatureInfo() {
        return this.getPropertyInfo();
    }

    @Override
    protected Object evaluate(Iterator args) {
        return this.get();
    }

    @Override
    protected List<IType> getFullArgTypes() {
        return new ArrayList<IType>();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundPropertyReference that = (BoundPropertyReference)o;
        if (this._ctx != null ? !this._ctx.equals(that._ctx) : that._ctx != null) {
            return false;
        }
        if (this._pi != null ? !this._pi.equals(that._pi) : that._pi != null) {
            return false;
        }
        return !(this._rootType != null ? !this._rootType.equals(that._rootType) : that._rootType != null);
    }

    public int hashCode() {
        int result = this._pi != null ? this._pi.hashCode() : 0;
        result = 31 * result + (this._rootType != null ? this._rootType.hashCode() : 0);
        result = 31 * result + (this._ctx != null ? this._ctx.hashCode() : 0);
        return result;
    }
}

