/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.features;

import gw.lang.PublishedName;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.features.BlockWrapper;
import gw.lang.reflect.features.FeatureReference;
import gw.lang.reflect.features.IConstructorReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class ConstructorReference<R, T>
extends FeatureReference<R, T>
implements IConstructorReference<R, T> {
    private IConstructorInfo _ci;
    private Object[] _boundValues;

    public ConstructorReference(IType rootType, IType[] params, Object[] boundValues) {
        ITypeInfo typeInfo = rootType.getTypeInfo();
        this._ci = typeInfo instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)typeInfo).getConstructor(rootType, params) : typeInfo.getConstructor(params);
        this._boundValues = boundValues;
    }

    @Override
    public IConstructorInfo getConstructorInfo() {
        return this._ci;
    }

    @Override
    public Object evaluate(Object ... args) {
        return this.evaluate(Arrays.asList(args).iterator());
    }

    @Override
    public IType getRootType() {
        return this._ci.getType();
    }

    @Override
    public IFeatureInfo getFeatureInfo() {
        return this.getConstructorInfo();
    }

    @Override
    protected Object evaluate(Iterator args) {
        Object[] argArray = new Object[this._ci.getParameters().length];
        if (this._boundValues != null) {
            args = Arrays.asList(this._boundValues).iterator();
        }
        for (int i = 0; i < argArray.length; ++i) {
            argArray[i] = args.next();
        }
        return this._ci.getConstructor().newInstance(argArray);
    }

    @Override
    public List<IType> getFullArgTypes() {
        ArrayList<IType> lst = new ArrayList<IType>();
        if (this._boundValues == null) {
            for (IParameterInfo pi : this._ci.getParameters()) {
                lst.add(pi.getFeatureType());
            }
        }
        return lst;
    }

    @Override
    public T toBlock() {
        return (T)BlockWrapper.toBlock(this);
    }

    @Override
    public Object[] getBoundArgValues() {
        return this._boundValues;
    }

    @Override
    @PublishedName(value="invoke")
    public T getinvoke() {
        return this.toBlock();
    }

    public Object[] getBoundValues() {
        return this._boundValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstructorReference that = (ConstructorReference)o;
        if (!Arrays.equals(this._boundValues, that._boundValues)) {
            return false;
        }
        return !(this._ci != null ? !this._ci.equals(that._ci) : that._ci != null);
    }

    public int hashCode() {
        int result = this._ci != null ? this._ci.hashCode() : 0;
        result = 31 * result + (this._boundValues != null ? Arrays.hashCode(this._boundValues) : 0);
        return result;
    }
}

