/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.interval;

import gw.lang.reflect.interval.AbstractIntIterator;
import gw.lang.reflect.interval.NumberInterval;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class IntegerInterval
extends NumberInterval<Integer, IntegerInterval> {
    public IntegerInterval(Integer left, Integer right) {
        this(left, right, 1);
    }

    public IntegerInterval(Integer left, Integer right, int iStep) {
        this(left, right, iStep, true, true, false);
    }

    public IntegerInterval(Integer left, Integer right, int iStep, boolean bLeftClosed, boolean bRightClosed, boolean bReverse) {
        super(left, right, iStep, bLeftClosed, bRightClosed, bReverse);
        if (iStep <= 0) {
            throw new IllegalArgumentException("The step must be greater than 0: " + iStep);
        }
    }

    @Override
    public Iterator<Integer> iterateFromLeft() {
        return new ForwardIterator();
    }

    @Override
    public Iterator<Integer> iterateFromRight() {
        return new ReverseIterator();
    }

    @Override
    public Integer getFromLeft(int iStepIndex) {
        if (iStepIndex < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + iStepIndex);
        }
        if (!this.isLeftClosed()) {
            ++iStepIndex;
        }
        int value = (Integer)this.getLeftEndpoint() + (Integer)this.getStep() * iStepIndex;
        if (this.isRightClosed() ? value <= (Integer)this.getRightEndpoint() : value < (Integer)this.getRightEndpoint()) {
            return value;
        }
        return null;
    }

    @Override
    public Integer getFromRight(int iStepIndex) {
        if (iStepIndex < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + iStepIndex);
        }
        if (!this.isRightClosed()) {
            ++iStepIndex;
        }
        int value = (Integer)this.getRightEndpoint() - (Integer)this.getStep() * iStepIndex;
        if (this.isLeftClosed() ? value >= (Integer)this.getLeftEndpoint() : value > (Integer)this.getLeftEndpoint()) {
            return value;
        }
        return null;
    }

    private class ReverseIterator
    extends AbstractIntIterator {
        private int _csr;

        public ReverseIterator() {
            this._csr = (Integer)IntegerInterval.this.getRightEndpoint();
            if (!IntegerInterval.this.isRightClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this._csr > (Integer)IntegerInterval.this.getLeftEndpoint() || IntegerInterval.this.isLeftClosed() && this._csr == (Integer)IntegerInterval.this.getLeftEndpoint();
        }

        @Override
        public Integer next() {
            return this.nextInt();
        }

        @Override
        public int nextInt() {
            if (this._csr < (Integer)IntegerInterval.this.getLeftEndpoint() || !IntegerInterval.this.isLeftClosed() && this._csr == (Integer)IntegerInterval.this.getLeftEndpoint()) {
                throw new NoSuchElementException();
            }
            int ret = this._csr;
            this._csr -= ((Integer)IntegerInterval.this.getStep()).intValue();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class ForwardIterator
    extends AbstractIntIterator {
        private int _csr;

        public ForwardIterator() {
            this._csr = (Integer)IntegerInterval.this.getLeftEndpoint();
            if (!IntegerInterval.this.isLeftClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this._csr < (Integer)IntegerInterval.this.getRightEndpoint() || IntegerInterval.this.isRightClosed() && this._csr == (Integer)IntegerInterval.this.getRightEndpoint();
        }

        @Override
        public Integer next() {
            return this.nextInt();
        }

        @Override
        public int nextInt() {
            if (this._csr > (Integer)IntegerInterval.this.getRightEndpoint() || !IntegerInterval.this.isRightClosed() && this._csr == (Integer)IntegerInterval.this.getRightEndpoint()) {
                throw new NoSuchElementException();
            }
            int ret = this._csr;
            this._csr += ((Integer)IntegerInterval.this.getStep()).intValue();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

