/*
 * Decompiled with CFR 0.152.
 */
package gw.util;

import gw.util.SpaceEfficientHashMap;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ScopedMap<K, V>
extends AbstractMap<K, V> {
    private final ScopedMap<K, V> _parent;
    private Map<K, V> _overlayMap = Collections.emptyMap();

    public ScopedMap() {
        this._parent = null;
    }

    private ScopedMap(ScopedMap<K, V> parent) {
        this._parent = parent;
    }

    @Override
    public int size() {
        return this.getEntryMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getEntryMap().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getEntryMap().containsValue(value);
    }

    @Override
    public V get(Object key) {
        V value = this._overlayMap.get(key);
        if (value != null) {
            return value;
        }
        if (this._overlayMap.containsKey(key)) {
            return null;
        }
        return this._parent == null ? null : (V)this._parent.get(key);
    }

    @Override
    public V put(K key, V value) {
        this.initOverlayMap();
        V oldValue = this.get(key);
        this._overlayMap.put(key, value);
        return oldValue;
    }

    @Override
    public V remove(Object key) {
        this.initOverlayMap();
        V oldValue = this.get(key);
        this._overlayMap.put(key, null);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public ScopedMap<K, V> pushScope() {
        if (!this._overlayMap.isEmpty()) {
            ((SpaceEfficientHashMap)this._overlayMap).trimToSize();
        }
        return new ScopedMap<K, V>(this);
    }

    public ScopedMap<K, V> popScope() {
        return this._parent;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        return this.getEntryMap().keySet();
    }

    @Override
    public Collection<V> values() {
        return this.getEntryMap().values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.getEntryMap().entrySet();
    }

    private Map<K, V> getEntryMap() {
        HashMap results = new HashMap();
        this.getEntryMap(results);
        return results;
    }

    private void getEntryMap(Map<K, V> results) {
        if (this._parent != null) {
            super.getEntryMap(results);
        }
        this.initOverlayMap();
        results.putAll(this._overlayMap);
    }

    public boolean containsKeyDirect(K key) {
        return this._overlayMap.containsKey(key);
    }

    public V getDirect(K key) {
        return this._overlayMap.get(key);
    }

    private void initOverlayMap() {
        if (this._overlayMap == Collections.emptyMap()) {
            this._overlayMap = new SpaceEfficientHashMap();
        }
    }
}

