/*
 * Decompiled with CFR 0.152.
 */
package gw.util;

import gw.util.GosuObjectUtil;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SpaceEfficientHashMap<K, V>
implements Map<K, V> {
    private static final Object EMPTY_KEY = new Object();
    private Object _keys = EMPTY_KEY;
    private Object _values;
    private static final int MAX_LIST_SIZE = 16;
    volatile transient int modCount;

    public SpaceEfficientHashMap() {
    }

    public SpaceEfficientHashMap(Map<? extends K, ? extends V> m) {
        this.putAll(m);
    }

    @Override
    public int size() {
        if (this.isObject()) {
            return this._keys == EMPTY_KEY ? 0 : 1;
        }
        if (this.isList()) {
            return ((List)this._keys).size();
        }
        return ((Map)this._keys).size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.isMap()) {
            return ((Map)this._keys).containsKey(key);
        }
        if (this.isList()) {
            List keyList = (List)this._keys;
            return keyList.contains(key);
        }
        return GosuObjectUtil.equals(this._keys, key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.isMap()) {
            return ((Map)this._keys).containsValue(value);
        }
        if (this.isList()) {
            List valueList = (List)this._values;
            return valueList.contains(value);
        }
        return this._keys != EMPTY_KEY && GosuObjectUtil.equals(this._values, value);
    }

    @Override
    public V get(Object key) {
        if (this.isMap()) {
            return ((Map)this._keys).get(key);
        }
        if (this.isList()) {
            List keyList = (List)this._keys;
            for (int i = 0; i < keyList.size(); ++i) {
                Object o = keyList.get(i);
                if (!GosuObjectUtil.equals(o, key)) continue;
                return (V)((List)this._values).get(i);
            }
            return null;
        }
        return (V)(this._keys != EMPTY_KEY && GosuObjectUtil.equals(this._keys, key) ? this._values : null);
    }

    @Override
    public V put(K key, V value) {
        if (this.isMap()) {
            return ((Map)this._keys).put(key, value);
        }
        if (this.isList()) {
            ArrayList keyList = (ArrayList)this._keys;
            ArrayList valueList = (ArrayList)this._values;
            for (int i = 0; i < keyList.size(); ++i) {
                Object o = keyList.get(i);
                if (!GosuObjectUtil.equals(o, key)) continue;
                Object oldValue = valueList.get(i);
                valueList.set(i, value);
                return (V)oldValue;
            }
            if (keyList.size() + 1 > 16) {
                HashMap<Object, Object> map = new HashMap<Object, Object>(keyList.size() + 1);
                for (int i = 0; i < keyList.size(); ++i) {
                    map.put(keyList.get(i), valueList.get(i));
                }
                map.put(key, value);
                this._keys = map;
                this._values = null;
            } else {
                keyList.add(key);
                valueList.add(value);
            }
            return null;
        }
        if (GosuObjectUtil.equals(this._keys, key)) {
            Object oldValue = this._values;
            this._values = value;
            return (V)oldValue;
        }
        if (this._keys == EMPTY_KEY) {
            this._keys = key;
            this._values = value;
            return null;
        }
        ArrayList<Object> keyList = new ArrayList<Object>(2);
        keyList.add(this._keys);
        keyList.add(key);
        ArrayList<Object> valueList = new ArrayList<Object>(2);
        valueList.add(this._values);
        valueList.add(value);
        this._keys = keyList;
        this._values = valueList;
        return null;
    }

    @Override
    public V remove(Object key) {
        if (this.isMap()) {
            return ((Map)this._keys).remove(key);
        }
        if (this.isList()) {
            ArrayList keyList = (ArrayList)this._keys;
            ArrayList valueList = (ArrayList)this._values;
            for (int i = 0; i < keyList.size(); ++i) {
                Object o = keyList.get(i);
                if (!GosuObjectUtil.equals(o, key)) continue;
                Object oldValue = valueList.get(i);
                keyList.remove(i);
                valueList.remove(i);
                return (V)oldValue;
            }
            return null;
        }
        if (GosuObjectUtil.equals(this._keys, key)) {
            Object oldValue = this._values;
            this._values = null;
            this._keys = EMPTY_KEY;
            return (V)oldValue;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (m.isEmpty()) {
            return;
        }
        if (this.isMap()) {
            ((Map)this._keys).putAll(m);
        } else if (m.size() < 10) {
            for (Map.Entry<K, V> entry : m.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        } else {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            if (this.isList()) {
                ArrayList keyList = (ArrayList)this._keys;
                ArrayList valueList = (ArrayList)this._values;
                for (int i = 0; i < keyList.size(); ++i) {
                    map.put(keyList.get(i), valueList.get(i));
                }
            } else if (this._keys != EMPTY_KEY) {
                map.put(this._keys, this._values);
            }
            map.putAll(m);
            this._keys = map;
            this._values = null;
            this.trimToSize();
        }
    }

    @Override
    public void clear() {
        this._keys = EMPTY_KEY;
        this._values = null;
    }

    @Override
    public Set<K> keySet() {
        if (this.isMap()) {
            return ((Map)this._keys).keySet();
        }
        return new MyListSet(true);
    }

    @Override
    public Collection<V> values() {
        if (this.isMap()) {
            return ((Map)this._keys).values();
        }
        return new MyListSet(false);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.isMap()) {
            return ((Map)this._keys).entrySet();
        }
        return new MyEntrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, V> e : this.entrySet()) {
                K key = e.getKey();
                V value = e.getValue();
                if (!(value == null ? m.get(key) != null || !m.containsKey(key) : !value.equals(m.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = 0;
        Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
        while (i.hasNext()) {
            h += i.next().hashCode();
        }
        return h;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        int i = 0;
        for (Map.Entry<K, V> entry : this.entrySet()) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(entry.getKey()).append("=").append(entry.getValue());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    private boolean isObject() {
        return !this.isList() && !this.isMap();
    }

    private boolean isList() {
        return this._keys instanceof List;
    }

    private boolean isMap() {
        return this._keys instanceof Map;
    }

    public void trimToSize() {
        if (this.isList()) {
            ArrayList keyList = (ArrayList)this._keys;
            ArrayList valueList = (ArrayList)this._values;
            if (keyList.size() == 0) {
                this._keys = EMPTY_KEY;
                this._values = null;
            } else if (keyList.size() == 1) {
                this._keys = keyList.get(0);
                this._values = valueList.get(0);
            } else {
                keyList.trimToSize();
                valueList.trimToSize();
            }
        } else if (this.isMap()) {
            Map map = (Map)this._keys;
            if (map.size() == 0) {
                this._keys = EMPTY_KEY;
                this._values = null;
            } else if (map.size() == 1) {
                Map.Entry entry = map.entrySet().iterator().next();
                this._keys = entry.getKey();
                this._values = entry.getValue();
            } else if (map.size() <= 16) {
                ArrayList keyList = new ArrayList(map.size());
                ArrayList valueList = new ArrayList(map.size());
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = iterator.next();
                    keyList.add(entry.getKey());
                    valueList.add(entry.getValue());
                }
                keyList.trimToSize();
                valueList.trimToSize();
                this._keys = keyList;
                this._values = valueList;
            } else {
                this._keys = new HashMap(map);
            }
        }
    }

    private final class MyEntrySet<S, T>
    extends AbstractSet<Map.Entry<S, T>> {
        MyEntrySet() {
        }

        @Override
        public Iterator<Map.Entry<S, T>> iterator() {
            if (SpaceEfficientHashMap.this.isList()) {
                return new Iterator<Map.Entry<S, T>>(){
                    private Iterator _kit;
                    private Iterator _vit;
                    {
                        this._kit = ((List)SpaceEfficientHashMap.this._keys).iterator();
                        this._vit = ((List)SpaceEfficientHashMap.this._values).iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this._kit.hasNext();
                    }

                    @Override
                    public Map.Entry<S, T> next() {
                        Object key = this._kit.next();
                        Object value = this._vit.next();
                        return new AbstractMap.SimpleEntry(key, value);
                    }

                    @Override
                    public void remove() {
                        this._kit.remove();
                        this._vit.remove();
                    }
                };
            }
            if (SpaceEfficientHashMap.this._keys == EMPTY_KEY) {
                return new Iterator<Map.Entry<S, T>>(){

                    @Override
                    public boolean hasNext() {
                        return false;
                    }

                    @Override
                    public Map.Entry<S, T> next() {
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new NoSuchElementException();
                    }
                };
            }
            return new Iterator<Map.Entry<S, T>>(){
                boolean _onFirst = true;

                @Override
                public boolean hasNext() {
                    return this._onFirst;
                }

                @Override
                public Map.Entry<S, T> next() {
                    if (!this._onFirst) {
                        throw new NoSuchElementException();
                    }
                    this._onFirst = false;
                    return new AbstractMap.SimpleEntry<Object, Object>(SpaceEfficientHashMap.this._keys, SpaceEfficientHashMap.this._values);
                }

                @Override
                public void remove() {
                    SpaceEfficientHashMap.this._keys = null;
                    SpaceEfficientHashMap.this._values = null;
                }
            };
        }

        @Override
        public int size() {
            return SpaceEfficientHashMap.this.isList() ? ((List)SpaceEfficientHashMap.this._keys).size() : (SpaceEfficientHashMap.this._keys == EMPTY_KEY ? 0 : 1);
        }

        @Override
        public boolean contains(Object o) {
            return SpaceEfficientHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return SpaceEfficientHashMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            SpaceEfficientHashMap.this.clear();
        }
    }

    private final class MyListSet<T>
    extends AbstractSet<T> {
        boolean _returnKeySet;

        MyListSet(boolean returnKeySet) {
            this._returnKeySet = returnKeySet;
        }

        @Override
        public Iterator<T> iterator() {
            if (SpaceEfficientHashMap.this.isList()) {
                return new Iterator<T>(){
                    private Iterator _kit;
                    private Iterator _vit;
                    {
                        this._kit = ((List)SpaceEfficientHashMap.this._keys).iterator();
                        this._vit = ((List)SpaceEfficientHashMap.this._values).iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this._kit.hasNext();
                    }

                    @Override
                    public T next() {
                        Object key = this._kit.next();
                        Object value = this._vit.next();
                        return MyListSet.this._returnKeySet ? key : value;
                    }

                    @Override
                    public void remove() {
                        this._kit.remove();
                        this._vit.remove();
                    }
                };
            }
            if (SpaceEfficientHashMap.this._keys == EMPTY_KEY && SpaceEfficientHashMap.this._values == null) {
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return false;
                    }

                    @Override
                    public T next() {
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new NoSuchElementException();
                    }
                };
            }
            return new Iterator<T>(){
                boolean _onFirst = true;

                @Override
                public boolean hasNext() {
                    return this._onFirst;
                }

                @Override
                public T next() {
                    if (!this._onFirst) {
                        throw new NoSuchElementException();
                    }
                    this._onFirst = false;
                    if (MyListSet.this._returnKeySet) {
                        return SpaceEfficientHashMap.this._keys;
                    }
                    return SpaceEfficientHashMap.this._values;
                }

                @Override
                public void remove() {
                    if (this._onFirst) {
                        throw new IllegalStateException();
                    }
                    SpaceEfficientHashMap.this._keys = EMPTY_KEY;
                    SpaceEfficientHashMap.this._values = null;
                }
            };
        }

        @Override
        public int size() {
            return SpaceEfficientHashMap.this.isList() ? ((List)SpaceEfficientHashMap.this._keys).size() : (SpaceEfficientHashMap.this._keys == EMPTY_KEY ? 0 : 1);
        }

        @Override
        public boolean contains(Object o) {
            if (this._returnKeySet) {
                return SpaceEfficientHashMap.this.containsKey(o);
            }
            return SpaceEfficientHashMap.this.containsValue(o);
        }

        @Override
        public boolean remove(Object o) {
            if (this._returnKeySet) {
                return SpaceEfficientHashMap.this.remove(o) != null;
            }
            Iterator<T> e = this.iterator();
            if (o == null) {
                while (e.hasNext()) {
                    if (e.next() != null) continue;
                    e.remove();
                    return true;
                }
            } else {
                while (e.hasNext()) {
                    if (!o.equals(e.next())) continue;
                    e.remove();
                    return true;
                }
            }
            return false;
        }

        @Override
        public void clear() {
            SpaceEfficientHashMap.this.clear();
        }
    }
}

