/*
 * Decompiled with CFR 0.152.
 */
package gw.util;

import gw.util.ILogger;

public class SystemOutLogger
implements ILogger {
    LoggingLevel _level = LoggingLevel.WARN;

    public SystemOutLogger() {
    }

    public SystemOutLogger(LoggingLevel level) {
        this.setLevel(level);
    }

    public void setLevel(LoggingLevel level) {
        this._level = level;
    }

    @Override
    public String getName() {
        return "SystemOutLogger";
    }

    @Override
    public void trace(Object o) {
        this.log(LoggingLevel.TRACE, o);
    }

    @Override
    public void trace(Object o, Throwable throwable) {
        this.log(LoggingLevel.TRACE, o, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return this._level.compareTo(LoggingLevel.TRACE) < 0;
    }

    @Override
    public void info(Object o, Throwable throwable) {
        this.log(LoggingLevel.INFO, o, throwable);
    }

    @Override
    public void debug(Object s) {
        this.log(LoggingLevel.DEBUG, s);
    }

    @Override
    public void debug(Object s, Throwable throwable) {
        this.log(LoggingLevel.DEBUG, s, throwable);
    }

    @Override
    public boolean isDebugEnabled() {
        return this._level.compareTo(LoggingLevel.DEBUG) < 0;
    }

    @Override
    public void info(Object msg) {
        this.log(LoggingLevel.INFO, msg);
    }

    @Override
    public boolean isInfoEnabled() {
        return this._level.compareTo(LoggingLevel.INFO) < 0;
    }

    @Override
    public void warn(Object msg) {
        this.log(LoggingLevel.WARN, msg);
    }

    @Override
    public void warn(Object msg, Throwable throwable) {
        this.log(LoggingLevel.WARN, msg, throwable);
    }

    public boolean isWarnEnabled() {
        return this._level.compareTo(LoggingLevel.WARN) < 0;
    }

    @Override
    public void error(Object msg) {
        this.log(LoggingLevel.ERROR, msg);
    }

    @Override
    public void error(Object msg, Throwable throwable) {
        this.log(LoggingLevel.ERROR, msg, throwable);
    }

    public boolean isErrorEnabled() {
        return this._level.compareTo(LoggingLevel.ERROR) < 0;
    }

    @Override
    public void fatal(Object msg) {
        this.log(LoggingLevel.ERROR, msg);
    }

    @Override
    public void fatal(Object msg, Throwable throwable) {
        this.log(LoggingLevel.ERROR, msg, throwable);
    }

    public boolean isFatalErrorEnabled() {
        return true;
    }

    protected void log(LoggingLevel level, Object msg) {
        this.log(level, msg, null);
    }

    protected void log(LoggingLevel level, Object msg, Throwable t) {
        if (this._level.compareTo(level) <= 0) {
            System.out.println(msg);
            if (t != null) {
                t.printStackTrace();
            }
        }
    }

    public static enum LoggingLevel {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

