/*
 * Decompiled with CFR 0.152.
 */
package gw.util.cache;

import gw.util.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class FqnCacheNode<K> {
    private final String name;
    private final FqnCacheNode<K> parent;
    private K userData;
    private Map<String, FqnCacheNode<K>> children;

    public FqnCacheNode(String text, FqnCacheNode<K> parent) {
        this.name = text;
        this.parent = parent;
    }

    public final FqnCacheNode<K> getChild(String segment) {
        if (this.children != null) {
            return this.children.get(segment);
        }
        return null;
    }

    public final void clear() {
        this.children = null;
    }

    public FqnCacheNode<K> getOrCreateChild(String segment) {
        FqnCacheNode<K> node;
        if (this.children == null) {
            this.children = new ConcurrentHashMap<String, FqnCacheNode<K>>(2);
        }
        if ((node = this.children.get(segment)) == null) {
            node = new FqnCacheNode<K>(segment, this);
            this.children.put(segment, node);
        }
        return node;
    }

    public final void delete() {
        super.deleteChild(this);
    }

    private void deleteChild(FqnCacheNode<K> child) {
        if (this.children != null) {
            this.children.remove(child.name);
            if (this.children.isEmpty()) {
                this.children = null;
            }
        }
    }

    public final K getUserData() {
        return this.userData;
    }

    public final void setUserData(K userData) {
        this.userData = userData;
    }

    public final boolean isLeaf() {
        return this.children == null || this.children.isEmpty();
    }

    public void collectNames(Set<String> names, String s) {
        if (this.children != null) {
            for (FqnCacheNode<K> child : this.children.values()) {
                String path;
                String string = path = s.length() == 0 ? child.name : s + super.separator() + child.name;
                if (child.isLeaf()) {
                    names.add(path);
                    continue;
                }
                child.collectNames(names, path);
            }
        }
    }

    public final Collection<FqnCacheNode<K>> getChildren() {
        if (this.children != null) {
            return this.children.values();
        }
        return Collections.emptySet();
    }

    public final boolean visitDepthFirst(Predicate<K> visitor) {
        if (this.children != null) {
            ArrayList<FqnCacheNode<K>> copy = new ArrayList<FqnCacheNode<K>>(this.children.values());
            for (FqnCacheNode fqnCacheNode : copy) {
                if (fqnCacheNode.visitDepthFirst(visitor)) continue;
                return false;
            }
        }
        return visitor.evaluate(this.getUserData());
    }

    public final boolean visitNodeDepthFirst(Predicate<FqnCacheNode> visitor) {
        if (this.children != null) {
            ArrayList<FqnCacheNode<K>> copy = new ArrayList<FqnCacheNode<K>>(this.children.values());
            for (FqnCacheNode fqnCacheNode : copy) {
                if (fqnCacheNode.visitNodeDepthFirst(visitor)) continue;
                return false;
            }
        }
        return visitor.evaluate(this);
    }

    public final boolean visitBreadthFirst(Predicate<K> visitor) {
        if (!visitor.evaluate(this.getUserData())) {
            return false;
        }
        if (this.children != null) {
            ArrayList<FqnCacheNode<K>> copy = new ArrayList<FqnCacheNode<K>>(this.children.values());
            for (FqnCacheNode fqnCacheNode : copy) {
                fqnCacheNode.visitBreadthFirst(visitor);
            }
        }
        return true;
    }

    public final boolean visitNodeBreadthFirst(Predicate<FqnCacheNode> visitor) {
        if (!visitor.evaluate(this)) {
            return false;
        }
        if (this.children != null) {
            ArrayList<FqnCacheNode<K>> copy = new ArrayList<FqnCacheNode<K>>(this.children.values());
            for (FqnCacheNode fqnCacheNode : copy) {
                fqnCacheNode.visitNodeBreadthFirst(visitor);
            }
        }
        return true;
    }

    public final String getName() {
        return this.name;
    }

    public final String getFqn() {
        StringBuilder sb = new StringBuilder();
        FqnCacheNode<K> node = this;
        while (node.parent != null) {
            String str = node.name + (sb.length() == 0 ? "" : this.separator());
            sb.insert(0, str);
            node = node.parent;
        }
        return sb.toString();
    }

    private String separator() {
        char c = this.name.charAt(0);
        return c == '[' || c == '<' ? "" : ".";
    }

    public String toString() {
        return this.name;
    }
}

