/*
 * Decompiled with CFR 0.152.
 */
package gw.util.concurrent;

public abstract class LocklessLazyVar<T> {
    protected static final Object NULL = new Object();
    private volatile T _val = null;

    public final T get() {
        T result = this._val;
        if (result == NULL) {
            return null;
        }
        if (result == null) {
            result = this.init();
            this._val = result == null ? NULL : result;
        }
        return result;
    }

    protected abstract T init();

    public final T clear() {
        T hold = this._val;
        this._val = null;
        return hold;
    }

    protected void initDirectly(T val) {
        this._val = val;
    }

    public boolean isLoaded() {
        return this._val != null;
    }

    @Deprecated
    public static <Q> LocklessLazyVar<Q> make(final LazyVarInit<Q> init) {
        return new LocklessLazyVar<Q>(){

            @Override
            protected Q init() {
                return init.init();
            }
        };
    }

    public static interface LazyVarInit<Q> {
        public Q init();
    }
}

