/*
 * Decompiled with CFR 0.152.
 */
package gw.date;

public enum Month {
    JANUARY,
    FEBRUARY,
    MARCH,
    APRIL,
    MAY,
    JUNE,
    JULY,
    AUGUST,
    SEPTEMBER,
    OCTOBER,
    NOVEMBER,
    DECEMBER;

    private static final Month[] _valueLookup;

    public static Month fromCalendarMonth(int calendarMonth) {
        if (calendarMonth < 0 || calendarMonth >= _valueLookup.length) {
            throw new IllegalArgumentException(calendarMonth + " is not a valid Calendar month");
        }
        return _valueLookup[calendarMonth];
    }

    public int toCalendarMonth() {
        return this.ordinal();
    }

    static {
        _valueLookup = Month.values();
    }
}

