/*
 * Decompiled with CFR 0.152.
 */
package gw.fs.watcher;

import gw.lang.UnstableAPI;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;

@UnstableAPI
public class DirectoryWatcher {
    private WatchService _watchService;
    private Map<WatchKey, Path> _watchedDirectories;

    public DirectoryWatcher() {
        try {
            this._watchService = FileSystems.getDefault().newWatchService();
            this._watchedDirectories = new HashMap<WatchKey, Path>();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void stopWatching() {
        try {
            this._watchService.close();
            this._watchService = null;
            this._watchedDirectories = null;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not stop watching directories!", e);
        }
    }

    public void watchDirectoryTree(Path dir) {
        if (this._watchedDirectories == null) {
            throw new IllegalStateException("DirectoryWatcher.close() was called. Please make a new instance.");
        }
        try {
            if (Files.exists(dir, new LinkOption[0])) {
                Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        DirectoryWatcher.this.watchDirectory(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void watchDirectory(Path dir) throws IOException {
        try {
            WatchKey key = dir.register(this._watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            this._watchedDirectories.put(key, dir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<Path, FileEvent> getChangesSinceLastTime() {
        WatchKey key;
        if (this._watchedDirectories == null) {
            throw new IllegalStateException("DirectoryWatcher.close() was called. Please make a new instance.");
        }
        HashMap<Path, FileEvent> events = new HashMap<Path, FileEvent>();
        while ((key = this._watchService.poll()) != null) {
            Path dir = this._watchedDirectories.get(key);
            if (dir == null) {
                throw new IllegalStateException("Got a WatchKey for a Path that we didn't watch");
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                Object context = event.context();
                if (!(context instanceof Path)) continue;
                Path changedFile = dir.resolve((Path)context);
                WatchEvent.Kind<?> eventKind = event.kind();
                if (eventKind == StandardWatchEventKinds.ENTRY_CREATE) {
                    if (events.get(changedFile) == FileEvent.DELETE) {
                        events.put(changedFile, FileEvent.MODIFY);
                        continue;
                    }
                    events.put(changedFile, FileEvent.CREATE);
                    continue;
                }
                if (eventKind == StandardWatchEventKinds.ENTRY_MODIFY) {
                    if (events.containsKey(changedFile)) continue;
                    events.put(changedFile, FileEvent.MODIFY);
                    continue;
                }
                if (eventKind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                if (events.get(changedFile) == FileEvent.CREATE) {
                    events.remove(changedFile);
                    continue;
                }
                events.put(changedFile, FileEvent.DELETE);
            }
            if (key.reset()) continue;
            this._watchedDirectories.remove(key);
        }
        return events;
    }

    public static enum FileEvent {
        CREATE,
        MODIFY,
        DELETE;

    }
}

