/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.parser;

import gw.lang.parser.IFileContext;
import gw.lang.parser.IFunctionSymbol;
import gw.lang.parser.IGosuParser;
import gw.lang.parser.IScriptPartId;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.ITokenizerInstructor;
import gw.lang.parser.ITypeUsesMap;
import gw.lang.parser.resources.ResourceKey;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ParserOptions {
    private ITypeUsesMap _typeUsesMap;
    private IType _expectedType;
    private String _strEnclosingType;
    private ITokenizerInstructor _ti;
    private IFileContext _fileContext;
    private boolean _bGenRootExprAccess;
    private ISymbolTable _additionalDFSDecls;
    private boolean _captureSymbolsForEval;
    private Map<String, List<IFunctionSymbol>> _declSymbols;
    private boolean _shouldOptimize = true;
    private IGosuParser _parser;
    private IType _superType;
    private boolean _bStatementsOnly;
    private IScriptPartId _partId;
    private boolean _throwawayProgram;
    private Object _ctxInferenceMgr;
    private Set<ResourceKey> _ignoreWarnings = new HashSet<ResourceKey>();
    private boolean _allowUses;
    private boolean _bAnon;

    public ParserOptions withParser(IGosuParser parser) {
        this._parser = parser;
        return this;
    }

    public ParserOptions withTypeUsesMap(ITypeUsesMap typeUsesMap) {
        this._typeUsesMap = typeUsesMap;
        return this;
    }

    public ParserOptions withEnclosingType(String strEnclosingType) {
        this._strEnclosingType = strEnclosingType;
        return this;
    }

    public ParserOptions withDefaultTypeUsesMap() {
        this._typeUsesMap = TypeSystem.getDefaultTypeUsesMap().copy();
        return this;
    }

    public ParserOptions withExpectedType(IType expectedType) {
        this._expectedType = expectedType;
        return this;
    }

    public ParserOptions withTokenizerInstructor(ITokenizerInstructor ti) {
        this._ti = ti;
        return this;
    }

    public ParserOptions withFileContext(IFileContext fileContext) {
        this._fileContext = fileContext;
        return this;
    }

    public ParserOptions withCtxInferenceMgr(Object ctxInferenceMgr) {
        this._ctxInferenceMgr = ctxInferenceMgr;
        return this;
    }

    public ParserOptions withGenRootExprAccess(boolean genRootExprAccess) {
        this._bGenRootExprAccess = genRootExprAccess;
        return this;
    }

    public ParserOptions withAdditionalDFSDecls(ISymbolTable additionalDFSDecls) {
        this._additionalDFSDecls = additionalDFSDecls;
        return this;
    }

    public ParserOptions withCaptureSymbolsForEval(boolean captureSymbolsForEval) {
        this._captureSymbolsForEval = captureSymbolsForEval;
        return this;
    }

    public ParserOptions withDeclSymbols(Map<String, List<IFunctionSymbol>> declSymbols) {
        this._declSymbols = declSymbols;
        return this;
    }

    public ParserOptions asThrowawayProgram() {
        this._throwawayProgram = true;
        return this;
    }

    public ParserOptions asAnonymous() {
        this._bAnon = true;
        return this;
    }

    public ParserOptions withStatementsOnly() {
        this._bStatementsOnly = true;
        return this;
    }

    public boolean isStatementsOnly() {
        return this._bStatementsOnly;
    }

    public void setParserOptions(IGosuParser parser) {
        parser.setTypeUsesMap(this._typeUsesMap);
        if (this._ti != null) {
            parser.setTokenizerInstructor(this._ti);
        }
        parser.setGenerateRootExpressionAccessForProgram(this._bGenRootExprAccess);
        if (this._additionalDFSDecls != null) {
            parser.putDfsDeclsInTable(this._additionalDFSDecls);
        }
        parser.setCaptureSymbolsForEval(this._captureSymbolsForEval);
        if (this._declSymbols != null) {
            parser.setDfsDeclInSetByName(this._declSymbols);
        }
        parser.setIgnoreWarnings(this._ignoreWarnings);
    }

    public IType getExpectedType() {
        return this._expectedType;
    }

    public String getEnclosingType() {
        return this._strEnclosingType;
    }

    public IFileContext getFileContext() {
        return this._fileContext;
    }

    public ITypeUsesMap getTypeUsesMap() {
        return this._typeUsesMap;
    }

    public ITokenizerInstructor getTi() {
        return this._ti;
    }

    public boolean isBGenRootExprAccess() {
        return this._bGenRootExprAccess;
    }

    public ISymbolTable getAdditionalDFSDecls() {
        return this._additionalDFSDecls;
    }

    public boolean isCaptureSymbolsForEval() {
        return this._captureSymbolsForEval;
    }

    public Map<String, List<IFunctionSymbol>> getDeclSymbols() {
        return this._declSymbols;
    }

    public ParserOptions withShouldOptimize(boolean shouldOptimize) {
        this._shouldOptimize = shouldOptimize;
        return this;
    }

    public boolean isShouldOptimize() {
        return this._shouldOptimize;
    }

    public IGosuParser getParser() {
        return this._parser;
    }

    public Object getCtxInferenceMgr() {
        return this._ctxInferenceMgr;
    }

    public ParserOptions withSuperType(IType superType) {
        this._superType = superType;
        return this;
    }

    public IType getSuperType() {
        return this._superType;
    }

    public ParserOptions withScriptPartId(IScriptPartId partId) {
        this._partId = partId;
        return this;
    }

    public IScriptPartId getScriptPartId() {
        return this._partId;
    }

    public boolean isThrowawayProgram() {
        return this._throwawayProgram;
    }

    public boolean isAnonymous() {
        return this._bAnon;
    }

    public boolean allowUses() {
        return this._allowUses;
    }

    public ParserOptions withIgnoreWarning(ResourceKey msgKey) {
        this._ignoreWarnings.add(msgKey);
        return this;
    }

    public ParserOptions allowUsesInBody() {
        this._allowUses = true;
        return this;
    }
}

