/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.parser;

import gw.util.StringPool;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Keyword
implements CharSequence {
    static final Map<String, Keyword> RESERVED_WORDS = new HashMap<String, Keyword>(90);
    public static final Keyword KW_true = Keyword.addReservedWord("true", true);
    public static final Keyword KW_false = Keyword.addReservedWord("false", true);
    public static final Keyword KW_NaN = Keyword.addReservedWord("NaN", true);
    public static final Keyword KW_Infinity = Keyword.addReservedWord("Infinity", true);
    public static final Keyword KW_and = Keyword.addReservedWord("and");
    public static final Keyword KW_or = Keyword.addReservedWord("or");
    public static final Keyword KW_not = Keyword.addReservedWord("not");
    public static final Keyword KW_null = Keyword.addReservedWord("null", true);
    public static final Keyword KW_length = Keyword.addReservedWord("length", true);
    public static final Keyword KW_in = Keyword.addReservedWord("in");
    public static final Keyword KW_out = Keyword.addReservedWord("out", true);
    public static final Keyword KW_startswith = Keyword.addReservedWord("startswith", true);
    public static final Keyword KW_contains = Keyword.addReservedWord("contains", true);
    public static final Keyword KW_where = Keyword.addReservedWord("where", true);
    public static final Keyword KW_var = Keyword.addReservedWord("var");
    public static final Keyword KW_delegate = Keyword.addReservedWord("delegate");
    public static final Keyword KW_represents = Keyword.addReservedWord("represents");
    public static final Keyword KW_as = Keyword.addReservedWord("as", true);
    public static final Keyword KW_typeof = Keyword.addReservedWord("typeof");
    public static final Keyword KW_statictypeof = Keyword.addReservedWord("statictypeof");
    public static final Keyword KW_typeis = Keyword.addReservedWord("typeis");
    public static final Keyword KW_typeas = Keyword.addReservedWord("typeas");
    public static final Keyword KW_print = Keyword.addReservedWord("print", true);
    public static final Keyword KW_package = Keyword.addReservedWord("package");
    public static final Keyword KW_uses = Keyword.addReservedWord("uses");
    public static final Keyword KW_if = Keyword.addReservedWord("if");
    public static final Keyword KW_else = Keyword.addReservedWord("else");
    public static final Keyword KW_foreach = Keyword.addReservedWord("foreach");
    public static final Keyword KW_for = Keyword.addReservedWord("for");
    public static final Keyword KW_index = Keyword.addReservedWord("index", true);
    public static final Keyword KW_iterator = Keyword.addReservedWord("iterator", true);
    public static final Keyword KW_while = Keyword.addReservedWord("while");
    public static final Keyword KW_do = Keyword.addReservedWord("do");
    public static final Keyword KW_continue = Keyword.addReservedWord("continue");
    public static final Keyword KW_break = Keyword.addReservedWord("break");
    public static final Keyword KW_return = Keyword.addReservedWord("return");
    public static final Keyword KW_construct = Keyword.addReservedWord("construct");
    public static final Keyword KW_function = Keyword.addReservedWord("function");
    public static final Keyword KW_property = Keyword.addReservedWord("property", false);
    public static final Keyword KW_get = Keyword.addReservedWord("get", true);
    public static final Keyword KW_set = Keyword.addReservedWord("set", true);
    public static final Keyword KW_try = Keyword.addReservedWord("try");
    public static final Keyword KW_catch = Keyword.addReservedWord("catch");
    public static final Keyword KW_finally = Keyword.addReservedWord("finally");
    public static final Keyword KW_this = Keyword.addReservedWord("this", true);
    public static final Keyword KW_throw = Keyword.addReservedWord("throw");
    public static final Keyword KW_assert = Keyword.addReservedWord("assert");
    public static final Keyword KW_new = Keyword.addReservedWord("new");
    public static final Keyword KW_switch = Keyword.addReservedWord("switch");
    public static final Keyword KW_case = Keyword.addReservedWord("case");
    public static final Keyword KW_default = Keyword.addReservedWord("default");
    public static final Keyword KW_eval = Keyword.addReservedWord("eval");
    public static final Keyword KW_private = Keyword.addReservedWord("private", true);
    public static final Keyword KW_internal = Keyword.addReservedWord("internal", true);
    public static final Keyword KW_protected = Keyword.addReservedWord("protected", true);
    public static final Keyword KW_public = Keyword.addReservedWord("public", true);
    public static final Keyword KW_abstract = Keyword.addReservedWord("abstract", true);
    public static final Keyword KW_override = Keyword.addReservedWord("override");
    public static final Keyword KW_hide = Keyword.addReservedWord("hide", true);
    public static final Keyword KW_final = Keyword.addReservedWord("final", true);
    public static final Keyword KW_static = Keyword.addReservedWord("static", true);
    public static final Keyword KW_extends = Keyword.addReservedWord("extends");
    public static final Keyword KW_transient = Keyword.addReservedWord("transient", false);
    public static final Keyword KW_implements = Keyword.addReservedWord("implements");
    public static final Keyword KW_readonly = Keyword.addReservedWord("readonly", true);
    public static final Keyword KW_class = Keyword.addReservedWord("class", false);
    public static final Keyword KW_interface = Keyword.addReservedWord("interface", false);
    public static final Keyword KW_annotation = Keyword.addReservedWord("annotation", false);
    public static final Keyword KW_structure = Keyword.addReservedWord("structure", false);
    public static final Keyword KW_enum = Keyword.addReservedWord("enum", false);
    public static final Keyword KW_super = Keyword.addReservedWord("super", false);
    public static final Keyword KW_outer = Keyword.addReservedWord("outer", true);
    public static final Keyword KW_void = Keyword.addReservedWord("void");
    public static final Keyword KW_boolean = Keyword.addReservedWord("boolean");
    public static final Keyword KW_char = Keyword.addReservedWord("char");
    public static final Keyword KW_byte = Keyword.addReservedWord("byte");
    public static final Keyword KW_short = Keyword.addReservedWord("short");
    public static final Keyword KW_int = Keyword.addReservedWord("int");
    public static final Keyword KW_long = Keyword.addReservedWord("long");
    public static final Keyword KW_float = Keyword.addReservedWord("float");
    public static final Keyword KW_double = Keyword.addReservedWord("double");
    public static final Keyword KW_block = Keyword.addReservedWord("block");
    public static final Keyword KW_enhancement = Keyword.addReservedWord("enhancement", true);
    public static final Keyword KW_classpath = Keyword.addReservedWord("classpath", true);
    public static final Keyword KW_typeloader = Keyword.addReservedWord("typeloader", true);
    public static final Keyword KW_using = Keyword.addReservedWord("using");
    private final String _strName;
    private final boolean _bValue;

    private Keyword(String strWord, boolean bValue) {
        this._strName = StringPool.get(strWord);
        this._bValue = bValue;
    }

    private static Keyword addReservedWord(String strWord) {
        return Keyword.addReservedWord(strWord, false);
    }

    private static Keyword addReservedWord(String strWord, boolean bValue) {
        if (RESERVED_WORDS.containsKey(strWord)) {
            throw new RuntimeException(strWord + " is already defined as a reserved word.");
        }
        Keyword keyword = new Keyword(strWord, bValue);
        RESERVED_WORDS.put(strWord, keyword);
        return keyword;
    }

    public static boolean isKeyword(String strWord) {
        return strWord != null && RESERVED_WORDS.containsKey(strWord);
    }

    public static boolean isValueKeyword(String strWord) {
        Keyword keyword = RESERVED_WORDS.get(strWord);
        return keyword != null && keyword.isValue();
    }

    public static boolean isReservedKeyword(String strWord) {
        Keyword keyword = RESERVED_WORDS.get(strWord);
        return keyword != null && !keyword.isValue();
    }

    public static Keyword get(String strWord) {
        return RESERVED_WORDS.get(strWord);
    }

    public static Set<String> getAll() {
        return RESERVED_WORDS.keySet();
    }

    @Override
    public int length() {
        return this._strName.length();
    }

    @Override
    public char charAt(int index) {
        return this._strName.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this._strName.subSequence(start, end);
    }

    public boolean isValue() {
        return this._bValue;
    }

    @Override
    public String toString() {
        return this._strName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Keyword keyword = (Keyword)o;
        return this._strName.equals(keyword._strName);
    }

    public int hashCode() {
        return this._strName.hashCode();
    }

    public boolean equals(String str) {
        return this._strName.equals(str);
    }

    public String getName() {
        return this._strName;
    }
}

