/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.gosuc.simple;

import gw.config.CommonServices;
import gw.config.ExecutionMode;
import gw.config.IMemoryMonitor;
import gw.config.IPlatformHelper;
import gw.config.Registry;
import gw.fs.FileFactory;
import gw.fs.IDirectory;
import gw.fs.IFile;
import gw.lang.gosuc.GosucModule;
import gw.lang.gosuc.simple.CompilerDriverException;
import gw.lang.gosuc.simple.CompilerMemoryMonitor;
import gw.lang.gosuc.simple.CompilerPlatformHelper;
import gw.lang.gosuc.simple.ICompilerDriver;
import gw.lang.gosuc.simple.IGosuCompiler;
import gw.lang.init.GosuInitialization;
import gw.lang.parser.ICoercionManager;
import gw.lang.parser.IParseIssue;
import gw.lang.parser.exceptions.ParseWarning;
import gw.lang.parser.statements.IClassFileStatement;
import gw.lang.parser.statements.IClassStatement;
import gw.lang.reflect.IEntityAccess;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.ISourceFileHandle;
import gw.lang.reflect.module.IExecutionEnvironment;
import gw.lang.reflect.module.IFileSystem;
import gw.lang.reflect.module.IModule;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class GosuCompiler
implements IGosuCompiler {
    protected GosuInitialization _gosuInitialization;
    protected File _compilingSourceFile;

    @Override
    public boolean compile(File sourceFile, ICompilerDriver driver) throws Exception {
        this._compilingSourceFile = sourceFile;
        IType type = this.getType(this._compilingSourceFile);
        if (type == null) {
            driver.sendCompileIssue(this._compilingSourceFile, 0, 0L, 0L, 0L, "Cannot find type in the Gosu Type System.");
            return false;
        }
        if (this.isCompilable(type)) {
            try {
                if (type.isValid()) {
                    this.createOutputFiles((IGosuClass)type, driver);
                }
            }
            catch (CompilerDriverException ex) {
                driver.sendCompileIssue(this._compilingSourceFile, 0, 0L, 0L, 0L, ex.getMessage());
                return false;
            }
            IClassStatement classElement = ((IGosuClass)type).getClassStatement();
            IClassFileStatement classFileStatement = classElement.getClassFileStatement();
            classElement = classFileStatement == null ? classElement : classFileStatement;
            ExecutionMode mode = CommonServices.getPlatformHelper().getExecutionMode();
            for (IParseIssue issue : classElement.getParseIssues()) {
                int category = issue instanceof ParseWarning ? 1 : 0;
                String message = mode == ExecutionMode.IDE ? issue.getUIMessage() : issue.getConsoleMessage();
                driver.sendCompileIssue(this._compilingSourceFile, category, issue.getTokenStart().intValue(), issue.getLine(), issue.getColumn(), message);
            }
        }
        return false;
    }

    private IType getType(File file) {
        IFile ifile = FileFactory.instance().getIFile(file);
        IModule module = TypeSystem.getGlobalModule();
        String[] typesForFile = TypeSystem.getTypesForFile(module, ifile);
        if (typesForFile.length != 0) {
            return TypeSystem.getByFullNameIfValid(typesForFile[0], module);
        }
        return null;
    }

    private boolean isCompilable(IType type) {
        IType doNotVerifyAnnotation = TypeSystem.getByFullNameIfValid("gw.testharness.DoNotVerifyResource");
        return type instanceof IGosuClass && !type.getTypeInfo().hasAnnotation(doNotVerifyAnnotation);
    }

    private void createOutputFiles(IGosuClass gsClass, ICompilerDriver driver) {
        IDirectory moduleOutputDirectory = TypeSystem.getGlobalModule().getOutputPath();
        if (moduleOutputDirectory == null) {
            throw new RuntimeException("Can't make class file, no output path defined.");
        }
        String outRelativePath = gsClass.getName().replace('.', File.separatorChar) + ".class";
        File child = new File(moduleOutputDirectory.getPath().getFileSystemPathString());
        this.mkdirs(child);
        try {
            StringTokenizer tokenizer = new StringTokenizer(outRelativePath, File.separator + "/");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if ((child = new File(child, token)).exists()) continue;
                if (token.endsWith(".class")) {
                    this.createNewFile(child);
                    continue;
                }
                this.mkDir(child);
            }
            this.populateClassFile(child, gsClass, driver);
            this.maybeCopySourceFile(child.getParentFile(), gsClass, this._compilingSourceFile, driver);
        }
        catch (Throwable e) {
            driver.sendCompileIssue(this._compilingSourceFile, 0, 0L, 0L, 0L, this.combine("Cannot create .class files.", GosuCompiler.getStackTrace(e)));
        }
    }

    public static String getStackTrace(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    private String toMessage(Throwable e) {
        String msg = e.getMessage();
        while (e.getCause() != null) {
            String newMsg = (e = e.getCause()).getMessage();
            if (newMsg == null) continue;
            msg = newMsg;
        }
        return msg;
    }

    private String combine(String message1, String message2) {
        message1 = message1 == null ? "" : message1 + "\n";
        return message1 + message2;
    }

    private void mkDir(File file) {
        file.mkdir();
    }

    private void mkdirs(File file) {
        file.mkdirs();
    }

    private void createNewFile(File file) throws IOException {
        file.createNewFile();
    }

    private void maybeCopySourceFile(File parent, IGosuClass gsClass, File sourceFile, ICompilerDriver driver) {
        File file;
        ISourceFileHandle sfh = gsClass.getSourceFileHandle();
        IFile srcFile = sfh.getFile();
        if (srcFile != null && (file = new File(srcFile.getPath().getFileSystemPathString())).isFile()) {
            try {
                File destFile = new File(parent, file.getName());
                this.copyFile(file, destFile);
                driver.registerOutput(this._compilingSourceFile, destFile);
            }
            catch (IOException e) {
                e.printStackTrace();
                driver.sendCompileIssue(sourceFile, 0, 0L, 0L, 0L, "Cannot copy source file to output folder.");
            }
        }
    }

    public void copyFile(File sourceFile, File destFile) throws IOException {
        if (sourceFile.isDirectory()) {
            this.mkdirs(destFile);
            return;
        }
        if (!destFile.exists()) {
            this.mkdirs(destFile.getParentFile());
            this.createNewFile(destFile);
        }
        try (FileChannel source = new FileInputStream(sourceFile).getChannel();
             FileChannel destination = new FileOutputStream(destFile).getChannel();){
            destination.transferFrom(source, 0L, source.size());
        }
    }

    private void populateClassFile(File outputFile, IGosuClass gosuClass, ICompilerDriver driver) throws IOException {
        byte[] bytes = TypeSystem.getGosuClassLoader().getBytes(gosuClass);
        Throwable throwable = null;
        try (FileOutputStream out = new FileOutputStream(outputFile);){
            ((OutputStream)out).write(bytes);
            driver.registerOutput(this._compilingSourceFile, outputFile);
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        for (IGosuClass iGosuClass : gosuClass.getInnerClasses()) {
            String innerClassName = String.format("%s$%s.class", outputFile.getName().substring(0, outputFile.getName().lastIndexOf(46)), iGosuClass.getRelativeName());
            File innerClassFile = new File(outputFile.getParent(), innerClassName);
            if (innerClassFile.isFile()) {
                this.createNewFile(innerClassFile);
            }
            this.populateClassFile(innerClassFile, iGosuClass, driver);
        }
    }

    @Override
    public long initializeGosu(List<String> sourceFolders, List<String> classpath, String outputPath) {
        long start = System.currentTimeMillis();
        CommonServices.getKernel().redefineService_Privileged(IFileSystem.class, GosuCompiler.createFileSystemInstance());
        CommonServices.getKernel().redefineService_Privileged(IMemoryMonitor.class, new CompilerMemoryMonitor());
        CommonServices.getKernel().redefineService_Privileged(IPlatformHelper.class, new CompilerPlatformHelper());
        if ("gw".equals(System.getProperty("compiler.type"))) {
            try {
                IEntityAccess access = (IEntityAccess)Class.forName("gw.internal.gosu.parser.gwPlatform.GWEntityAccess").newInstance();
                ICoercionManager coercionManager = (ICoercionManager)Class.forName("gw.internal.gosu.parser.gwPlatform.GWCoercionManager").newInstance();
                CommonServices.getKernel().redefineService_Privileged(IEntityAccess.class, access);
                CommonServices.getKernel().redefineService_Privileged(ICoercionManager.class, coercionManager);
                Registry.instance().setAllowEntityQueires(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        IExecutionEnvironment execEnv = TypeSystem.getExecutionEnvironment();
        this._gosuInitialization = GosuInitialization.instance(execEnv);
        GosucModule gosucModule = new GosucModule("_default_", sourceFolders, classpath, outputPath, Collections.emptyList(), Collections.emptyList());
        this._gosuInitialization.initializeCompiler(gosucModule);
        return System.currentTimeMillis() - start;
    }

    private static IFileSystem createFileSystemInstance() {
        try {
            Class<?> cls = Class.forName("gw.internal.gosu.module.fs.FileSystemImpl");
            Constructor<?> m = cls.getConstructor(IFileSystem.CachingMode.class);
            return (IFileSystem)m.newInstance(new Object[]{IFileSystem.CachingMode.FULL_CACHING});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void unitializeGosu() {
        TypeSystem.shutdown(TypeSystem.getExecutionEnvironment());
        if (this._gosuInitialization != null) {
            if (this._gosuInitialization.isInitialized()) {
                this._gosuInitialization.uninitializeCompiler();
            }
            this._gosuInitialization = null;
        }
    }

    @Override
    public boolean isPathIgnored(String sourceFile) {
        return CommonServices.getPlatformHelper().isPathIgnored(sourceFile);
    }
}

