/*
 * Decompiled with CFR 0.152.
 */
package gw.xml.simple;

import gw.xml.simple.DescendentsIterator;
import gw.xml.simple.SimpleXmlNodeWriter;
import gw.xml.simple.SimpleXmlParser;
import gw.xml.simple.XmlChildList;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SimpleXmlNode {
    private List<SimpleXmlNode> _children;
    private Map<String, String> _attributes;
    private String _name;
    private String _text;
    private SimpleXmlNode _parent;

    public SimpleXmlNode(String name) {
        this.setName(name);
        this._children = new XmlChildList<SimpleXmlNode>(this);
        this._attributes = new HashMap<String, String>();
    }

    public static SimpleXmlNode parse(String s) {
        return SimpleXmlParser.parseString(s);
    }

    public static SimpleXmlNode parse(File f) {
        return SimpleXmlParser.parseFile(f);
    }

    public static SimpleXmlNode parse(InputStream is) {
        return SimpleXmlParser.parseInputStream(is);
    }

    public List<SimpleXmlNode> getChildren() {
        return this._children;
    }

    public Iterable<SimpleXmlNode> getDescendents() {
        return new Iterable<SimpleXmlNode>(){

            @Override
            public Iterator<SimpleXmlNode> iterator() {
                return new DescendentsIterator(SimpleXmlNode.this);
            }
        };
    }

    public Map<String, String> getAttributes() {
        return this._attributes;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name of a SimpleXmlNode can never be set to null");
        }
        this._name = name;
    }

    public String getText() {
        return this._text;
    }

    public void setText(String text) {
        this._text = text;
    }

    public SimpleXmlNode getParent() {
        return this._parent;
    }

    void setParent(SimpleXmlNode parent) {
        this._parent = parent;
    }

    public SimpleXmlNode shallowCopy() {
        SimpleXmlNode copy = new SimpleXmlNode(this._name);
        copy.setText(this._text);
        copy.getAttributes().putAll(this._attributes);
        return copy;
    }

    public SimpleXmlNode deepCopy() {
        SimpleXmlNode rootCopy = this.shallowCopy();
        for (SimpleXmlNode child : this._children) {
            rootCopy.getChildren().add(child.deepCopy());
        }
        return rootCopy;
    }

    public String toXmlString() {
        return SimpleXmlNodeWriter.writeToString(this);
    }
}

