/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.annotation;

import gw.lang.reflect.TypeSystem;
import gw.util.SpaceEfficientHashMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Map;

public class Annotations {
    private Annotations() {
    }

    public static <T extends Annotation> Builder<T> builder(Class<T> annotationType) {
        return new Builder(annotationType);
    }

    public static <T extends Annotation> T create(Class<T> annotationType, Object value) {
        return new Builder(annotationType).withValue(value).create();
    }

    public static <T extends Annotation> T create(Class<T> annotationType) {
        return new Builder(annotationType).create();
    }

    public static class Builder<T extends Annotation> {
        private final Class<T> _annotationType;
        private final Map<Method, Element> _configuredElements;

        private Builder(Class<T> annotationType) {
            this._annotationType = annotationType;
            this._configuredElements = new SpaceEfficientHashMap<Method, Element>();
        }

        public Builder<T> withElement(String name, Object value) {
            Method elementMethod;
            try {
                elementMethod = this._annotationType.getMethod(name, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("No such element \"" + name + "\" defined on annotation type " + this._annotationType.getName());
            }
            if (elementMethod.getReturnType().isPrimitive()) {
                if (!TypeSystem.isBoxedTypeFor(TypeSystem.get(elementMethod.getReturnType()), TypeSystem.getFromObject(value))) {
                    throw new IllegalArgumentException("Element \"" + name + "\" on annotation type " + this._annotationType.getName() + " must be of type " + elementMethod.getReturnType() + ". Got " + value + (value == null ? "" : " (type " + value.getClass().getName() + ")"));
                }
            } else if (elementMethod.getReturnType().isArray() && elementMethod.getReturnType().getComponentType().isInstance(value)) {
                Object arr = Array.newInstance(value.getClass(), 1);
                Array.set(arr, 0, value);
                value = arr;
            } else if (value == null && elementMethod.getDefaultValue() != null) {
                value = elementMethod.getDefaultValue();
            } else {
                if (!elementMethod.getReturnType().isInstance(value)) {
                    throw new IllegalArgumentException("Element \"" + name + "\" on annotation type " + this._annotationType.getName() + " must be of type " + elementMethod.getReturnType() + ". Got " + value + (value == null ? "" : " (type " + value.getClass().getName() + ")"));
                }
                if (value instanceof Object[] && this.hasNullElements((Object[])value)) {
                    throw new IllegalArgumentException("Object arrays can't have null elements. Got " + Arrays.toString((Object[])value) + " for element \"" + name + "\"");
                }
            }
            this._configuredElements.put(elementMethod, new Element(value));
            return this;
        }

        public Builder<T> withValue(Object value) {
            return this.withElement("value", value);
        }

        public T create() {
            Map<Method, Element> elements = this.buildElements();
            ClassLoader cl = this.determineClassLoader();
            return (T)((Annotation)this._annotationType.cast(Proxy.newProxyInstance(cl, new Class[]{this._annotationType}, (InvocationHandler)new AnnotationInvocationHandler(elements, this._annotationType))));
        }

        private ClassLoader determineClassLoader() {
            if (this.canLoadAnnotation(Thread.currentThread().getContextClassLoader())) {
                return Thread.currentThread().getContextClassLoader();
            }
            return this._annotationType.getClassLoader();
        }

        private boolean canLoadAnnotation(ClassLoader cl) {
            Class<?> loadedVersion = null;
            if (cl != null) {
                try {
                    loadedVersion = Class.forName(this._annotationType.getName(), false, cl);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return loadedVersion == this._annotationType;
        }

        private boolean hasNullElements(Object[] array) {
            for (Object o : array) {
                if (o != null) continue;
                return true;
            }
            return false;
        }

        private Map<Method, Element> buildElements() {
            SpaceEfficientHashMap<Method, Element> elements = new SpaceEfficientHashMap<Method, Element>();
            if (this._annotationType != null) {
                for (Method elementMethod : TypeSystem.getDeclaredMethods(this._annotationType)) {
                    Element value = this._configuredElements.get(elementMethod);
                    if (value == null) {
                        Object defaultValue = elementMethod.getDefaultValue();
                        if (defaultValue == null) {
                            throw new IllegalStateException("Can't create annotation of type " + this._annotationType.getName() + ": missing value for element \"" + elementMethod.getName() + "\"");
                        }
                        value = new Element(defaultValue);
                    }
                    elements.put(elementMethod, value);
                }
            }
            return elements;
        }

        public static class AnnotationInvocationHandler
        implements InvocationHandler {
            private final Map<Method, Element> _elements;
            private final Class _annotationType;

            public AnnotationInvocationHandler(Map<Method, Element> elements, Class annotationType) {
                this._elements = elements;
                this._annotationType = annotationType;
            }

            public Class getAnnotationType() {
                return this._annotationType;
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object result;
                if (Object.class.equals(method.getDeclaringClass())) {
                    if ("equals".equals(method.getName())) {
                        result = this.equalsImpl(args[0]);
                    } else if ("hashCode".equals(method.getName())) {
                        result = this.hashCodeImpl();
                    } else {
                        boolean b = "toString".equals(method.getName());
                        assert (b);
                        result = this.toStringImpl();
                    }
                } else if (Annotation.class.equals(method.getDeclaringClass())) {
                    boolean b = "annotationType".equals(method.getName());
                    assert (b);
                    result = this._annotationType;
                } else {
                    boolean b = this._annotationType.equals(method.getDeclaringClass());
                    assert (b);
                    result = this._elements.get(method).getValue();
                }
                return result;
            }

            private String toStringImpl() {
                StringBuilder buf = new StringBuilder();
                buf.append('@').append(this._annotationType.getName());
                Method[] elementMethods = TypeSystem.getDeclaredMethods(this._annotationType);
                if (elementMethods.length > 0) {
                    buf.append('(');
                    for (int i = 0; i < elementMethods.length; ++i) {
                        if (i > 0) {
                            buf.append(", ");
                        }
                        Method elementMethod = elementMethods[i];
                        buf.append(elementMethod.getName()).append('=');
                        this._elements.get(elementMethod).valueToString(buf);
                    }
                    buf.append(')');
                }
                return buf.toString();
            }

            private int hashCodeImpl() {
                int hash = 0;
                for (Map.Entry<Method, Element> entry : this._elements.entrySet()) {
                    hash += this.hashElement(entry.getKey(), entry.getValue());
                }
                return hash;
            }

            private int hashElement(Method elementMethod, Element element) {
                return 127 * elementMethod.getName().hashCode() ^ element.valueHashCode();
            }

            private boolean equalsImpl(Object obj) throws Throwable {
                if (!this._annotationType.isInstance(obj)) {
                    return false;
                }
                for (Map.Entry<Method, Element> entry : this._elements.entrySet()) {
                    Object otherValue = this.getElementValue(obj, entry.getKey());
                    if (entry.getValue().valueEquals(otherValue)) continue;
                    return false;
                }
                return true;
            }

            private Object getElementValue(Object annotation, Method elementMethod) throws Throwable {
                try {
                    return elementMethod.invoke(annotation, new Object[0]);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
        }

        private static class Element {
            private final Object _value;
            private final int _arrayLength;
            private final Class<?> _componentType;

            Element(Object value) {
                assert (value != null);
                Class<?> valueClass = value.getClass();
                this._arrayLength = valueClass.isArray() ? Array.getLength(value) : -1;
                this._componentType = valueClass.getComponentType();
                this._value = Element.copyValueIfNecessary(value, this._arrayLength, this._componentType);
            }

            Object getValue() {
                return Element.copyValueIfNecessary(this._value, this._arrayLength, this._componentType);
            }

            boolean valueEquals(Object otherValue) {
                boolean result;
                if (this.isArray()) {
                    if (otherValue.getClass().isArray()) {
                        if (this._arrayLength == Array.getLength(otherValue)) {
                            boolean allElementsEqual = true;
                            for (int i = 0; i < this._arrayLength; ++i) {
                                if (Array.get(this._value, i).equals(Array.get(otherValue, i))) continue;
                                allElementsEqual = false;
                                break;
                            }
                            result = allElementsEqual;
                        } else {
                            result = false;
                        }
                    } else {
                        result = false;
                    }
                } else {
                    result = this._value.equals(otherValue);
                }
                return result;
            }

            int valueHashCode() {
                int hash;
                if (this.isArray()) {
                    int arrayHash = 1;
                    for (int i = 0; i < this._arrayLength; ++i) {
                        Object arrayElement = Array.get(this._value, i);
                        arrayHash = 31 * arrayHash + arrayElement.hashCode();
                    }
                    hash = arrayHash;
                } else {
                    hash = this._value.hashCode();
                }
                return hash;
            }

            void valueToString(StringBuilder buf) {
                if (this.isArray()) {
                    buf.append('[');
                    for (int i = 0; i < this._arrayLength; ++i) {
                        if (i > 0) {
                            buf.append(", ");
                        }
                        buf.append(Array.get(this._value, i));
                    }
                    buf.append(']');
                } else {
                    buf.append(this._value);
                }
            }

            private boolean isArray() {
                return this._componentType != null;
            }

            private static Object copyValueIfNecessary(Object value, int arrayLength, Class<?> componentType) {
                Object result;
                if (arrayLength > 0) {
                    result = Array.newInstance(componentType, arrayLength);
                    System.arraycopy(value, 0, result, 0, arrayLength);
                } else {
                    result = value;
                }
                return result;
            }
        }
    }
}

