/*
 * Decompiled with CFR 0.152.
 */
package gw.lang;

import gw.config.CommonServices;
import gw.lang.GosuShop;
import gw.lang.GosuVersion;
import gw.lang.ProgramFileContext;
import gw.lang.init.ClasspathToGosuPathEntryUtil;
import gw.lang.init.GosuInitialization;
import gw.lang.parser.GosuParserFactory;
import gw.lang.parser.IGosuProgramParser;
import gw.lang.parser.IParseResult;
import gw.lang.parser.ParserOptions;
import gw.lang.parser.StandardSymbolTable;
import gw.lang.parser.exceptions.ParseResultsException;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuProgram;
import gw.lang.reflect.java.JavaTypes;
import gw.util.OSPlatform;
import gw.util.StreamUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import sun.misc.URLClassPath;

public class Gosu {
    public static final String NOPACKAGE = "_nopackage_";
    public static final String GOSU_SCRATCHPAD_FQN = "_nopackage_.GosuScratchpad";
    private static List<File> _classpath;
    private static File _script;
    private static List<String> _rawArgs;

    public static void main(String[] args) {
        Gosu.start(args);
    }

    private static void checkArgsLength(int i, int length) {
        if (i >= length) {
            Gosu.showHelpAndQuit();
        }
    }

    private static void start(String[] args) {
        try {
            if (args.length == 0) {
                Gosu.launchEditor();
                return;
            }
            int i = 0;
            Gosu.checkArgsLength(i, args.length);
            String cpValue = null;
            boolean cmdLineCP = false;
            if (args[i].equals("-checkedArithmetic")) {
                Gosu.checkArgsLength(++i, args.length);
                System.setProperty("checkedArithmetic", "true");
            }
            if (args[i].equals("-classpath")) {
                cmdLineCP = true;
                Gosu.checkArgsLength(i += 2, args.length);
                cpValue = args[i - 1];
            }
            if (args[i].equals("-e")) {
                List<File> classpath = Gosu.makeClasspath(cpValue, "", cmdLineCP);
                Gosu.init(classpath);
                Gosu.runWithInlineScript(args[i + 1], Gosu.collectArgs(i + 2, args));
            } else {
                File script = new File(args[i]);
                if (!script.isFile() || !script.exists()) {
                    Gosu.showHelpAndQuit();
                }
                if (cpValue == null) {
                    cpValue = Gosu.extractClassPathFromSrc(script.getAbsolutePath());
                }
                List<File> classpath = Gosu.makeClasspath(cpValue, script.getAbsoluteFile().getParent(), cmdLineCP);
                Gosu.init(classpath);
                Gosu.runWithFile(script, Gosu.collectArgs(i + 1, args));
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    private static void launchEditor() throws Exception {
        Class<?> cls = Class.forName("editor.RunMe");
        Method m = cls.getMethod("launchEditor", new Class[0]);
        m.invoke(null, new Object[0]);
    }

    private static List<String> collectArgs(int i, String[] args) {
        ArrayList<String> scriptArgs = new ArrayList<String>();
        while (i < args.length) {
            scriptArgs.add(args[i]);
            ++i;
        }
        return scriptArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String extractClassPathFromSrc(String file) {
        BufferedReader br = null;
        String ret = null;
        try {
            int e;
            int b;
            String line;
            br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()).trim().isEmpty()) {
            }
            if (line.startsWith("classpath") && (b = line.indexOf(34)) != -1 && (e = line.indexOf(34, b + 1)) != -1) {
                ret = line.substring(b + 1, e);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
        return ret;
    }

    private static List<File> makeClasspath(String cpValue, String scriptRoot, boolean cmdLineCP) {
        ArrayList<File> cp = new ArrayList<File>();
        if (cpValue != null) {
            StringTokenizer st = new StringTokenizer(cpValue, ",", false);
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (s.contains(":") && !OSPlatform.isWindows() || s.contains(";")) {
                    System.err.println("WARNING: The Gosu classpath argument should be comma separated to avoid system dependencies.\nIt appears you are passing in a system-dependent path delimiter");
                }
                String pathname = cmdLineCP ? s : scriptRoot + File.separatorChar + s;
                cp.add(new File(pathname));
            }
        }
        return cp;
    }

    private static String makeFqn(File file) {
        String path = file.getAbsolutePath();
        int srcIndex = path.indexOf("src" + File.separatorChar);
        if (srcIndex >= 0) {
            String fqn = path.substring(srcIndex + 4).replace(File.separatorChar, '.');
            return fqn.substring(0, fqn.lastIndexOf(46));
        }
        String fqn = file.getName();
        fqn = "_nopackage_." + fqn.substring(0, fqn.lastIndexOf(46)).replace(" ", "");
        return fqn;
    }

    public static void setClasspath(List<File> classpath) {
        ClassLoader loader;
        classpath = new ArrayList<File>(classpath);
        Gosu.removeDups(classpath);
        if (classpath.equals(_classpath)) {
            return;
        }
        _classpath = classpath;
        ClassLoader classLoader = loader = TypeSystem.getCurrentModule() == null ? CommonServices.getEntityAccess().getPluginClassLoader() : TypeSystem.getGosuClassLoader().getActualLoader();
        if (loader instanceof URLClassLoader) {
            for (File entry : classpath) {
                try {
                    Method addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                    addURL.setAccessible(true);
                    addURL.invoke((Object)loader, entry.toURI().toURL());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        Gosu.reinitGosu(classpath);
        TypeSystem.refresh(true);
    }

    public static List<File> getClasspath() {
        return _classpath;
    }

    private static void reinitGosu(List<File> classpath) {
        try {
            GosuInitialization.instance(TypeSystem.getExecutionEnvironment()).reinitializeRuntime(ClasspathToGosuPathEntryUtil.convertClasspathToGosuPathEntries(classpath), new String[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void removeDups(List<File> classpath) {
        for (int i = classpath.size() - 1; i >= 0; --i) {
            File f = classpath.get(i);
            classpath.remove(i);
            if (classpath.contains(f)) continue;
            classpath.add(i, f);
        }
    }

    public static void init() {
        Gosu.init(null);
    }

    public static void init(List<File> classpath) {
        ArrayList<File> combined = new ArrayList<File>();
        combined.addAll(Gosu.deriveClasspathFrom(Gosu.class));
        if (classpath != null) {
            combined.addAll(classpath);
        }
        Gosu.setClasspath(combined);
    }

    public static boolean bootstrapGosuWhenInitiatedViaClassfile() {
        if (GosuInitialization.isAnythingInitialized() && GosuInitialization.instance(TypeSystem.getExecutionEnvironment()).isInitialized()) {
            return false;
        }
        Gosu.init();
        return true;
    }

    static void showHelpAndQuit() {
        System.out.println("Gosu version: " + Gosu.getVersion() + "\nUsage:\n" + "    gosu [-checkedArithmetic] [-classpath 'entry1,entry2...'] program.gsp [args...]\n" + "    gosu [-checkedArithmetic] [-classpath 'entry1,entry2...'] -e 'inline script' [args...]\n");
        System.exit(1);
    }

    public static List<File> deriveClasspathFrom(Class clazz) {
        LinkedList<File> ll = new LinkedList<File>();
        for (ClassLoader loader = clazz.getClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) continue;
            for (URL url : ((URLClassLoader)loader).getURLs()) {
                try {
                    File file = new File(url.toURI());
                    if (!file.exists()) continue;
                    ll.add(file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Gosu.addBootstrapClasses(ll);
        return ll;
    }

    private static void addBootstrapClasses(List<File> ll) {
        try {
            Method m = ClassLoader.class.getDeclaredMethod("getBootstrapClassPath", new Class[0]);
            m.setAccessible(true);
            URLClassPath bootstrapClassPath = (URLClassPath)m.invoke(null, new Object[0]);
            for (URL url : bootstrapClassPath.getURLs()) {
                try {
                    File file = new File(url.toURI());
                    if (!file.exists() || ll.contains(file)) continue;
                    ll.add(file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static GosuVersion getVersion() {
        InputStream in = Gosu.class.getClassLoader().getResourceAsStream("gw/lang/gosu-version.properties");
        if (in == null) {
            return new GosuVersion(0, 0);
        }
        Reader reader = StreamUtil.getInputStreamReader(in);
        return GosuVersion.parse(reader);
    }

    public static File getCurrentProgram() {
        return _script;
    }

    public static List<String> getRawArgs() {
        return _rawArgs;
    }

    private static void runWithFile(File script, List<String> args) throws IOException, ParseResultsException {
        _script = script;
        _rawArgs = args;
        byte[] bytes = StreamUtil.getContent(new BufferedInputStream(new FileInputStream(script)));
        String content = StreamUtil.toString(bytes);
        ProgramFileContext ctx = new ProgramFileContext(script, Gosu.makeFqn(script));
        IGosuProgramParser programParser = GosuParserFactory.createProgramParser();
        ParserOptions options = new ParserOptions().withFileContext(ctx);
        IParseResult result = programParser.parseExpressionOrProgram(content, new StandardSymbolTable(true), options);
        IGosuProgram program = result.getProgram();
        Object ret = program.getProgramInstance().evaluate(null);
        IType expressionType = result.getType();
        if (expressionType != null && !JavaTypes.pVOID().equals(expressionType)) {
            GosuShop.print(ret);
        }
    }

    private static void runWithInlineScript(String script, List<String> args) throws IOException, ParseResultsException {
        _script = null;
        _rawArgs = args;
        IGosuProgramParser programParser = GosuParserFactory.createProgramParser();
        IParseResult result = programParser.parseExpressionOrProgram(script, new StandardSymbolTable(true), new ParserOptions());
        IGosuProgram program = result.getProgram();
        Object ret = program.getProgramInstance().evaluate(null);
        IType expressionType = result.getType();
        if (expressionType != null && !JavaTypes.pVOID().equals(expressionType)) {
            GosuShop.print(ret);
        }
    }
}

