/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.ir.expression;

import gw.lang.UnstableAPI;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRType;
import gw.lang.ir.IRTypeConstants;

@UnstableAPI
public class IREqualityExpression
extends IRExpression {
    private IRExpression _lhs;
    private IRExpression _rhs;
    private boolean _equals;

    public IREqualityExpression(IRExpression lhs, IRExpression rhs, boolean equals) {
        if (lhs.getType().isPrimitive()) {
            if (!lhs.getType().equals(rhs.getType())) {
                throw new IllegalArgumentException("Cannot build an equality expression between a primitive type and something other than the same type. LHS type is " + lhs.getType().getName() + " and RHS type is " + rhs.getType().getName());
            }
        } else if (rhs.getType().isPrimitive()) {
            throw new IllegalArgumentException("Cannot build an equality expression between an object and a primitive type. LHS type is " + lhs.getType().getName() + " and RHS type is " + rhs.getType().getName());
        }
        this._lhs = lhs;
        this._rhs = rhs;
        this._equals = equals;
        this._lhs.setParent(this);
        this._rhs.setParent(this);
    }

    public IRExpression getLhs() {
        return this._lhs;
    }

    public IRExpression getRhs() {
        return this._rhs;
    }

    public boolean isEquals() {
        return this._equals;
    }

    @Override
    public IRType getType() {
        return IRTypeConstants.pBOOLEAN();
    }
}

