/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.lang.UnstableAPI;
import gw.lang.reflect.ITypeSystemRefresher;
import gw.lang.reflect.TypeSystem;

@UnstableAPI
public class TypeSystemRefresher
implements ITypeSystemRefresher {
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static TypeSystemRefresher _instance;

    public static synchronized TypeSystemRefresher getInstance() {
        if (_instance == null) {
            _instance = new TypeSystemRefresher();
        }
        return _instance;
    }

    protected TypeSystemRefresher() {
    }

    @Override
    public void maybeRefresh() {
        this.maybeRefresh(false);
    }

    @Override
    public void maybeRefresh(boolean force) {
        if (force || this.isNearMemoryBoundary()) {
            this.doRefresh();
        }
    }

    private void doRefresh() {
        TypeSystem.refresh(true);
        this.doPostRefreshCleanup();
        Runtime.getRuntime().gc();
        Thread.yield();
    }

    protected void doPostRefreshCleanup() {
    }

    private boolean isNearMemoryBoundary() {
        long lMaxHeap;
        long lFreeInHeap = Runtime.getRuntime().freeMemory();
        long lCurrentHeapSize = Runtime.getRuntime().totalMemory();
        return lCurrentHeapSize > (lMaxHeap = Runtime.getRuntime().maxMemory()) - 0x3200000L && lFreeInHeap < 0x3200000L;
    }
}

