/*
 * Decompiled with CFR 0.152.
 */
package gw.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.Properties;

public class StreamUtil {
    private StreamUtil() {
    }

    public static byte[] toBytes(CharSequence seq) {
        try {
            return seq.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String toString(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String toString(byte[] bytes, int offset, int length) {
        try {
            return new String(bytes, offset, length, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Properties toProperties(String propFileText) throws CharacterCodingException {
        CharsetEncoder encoder = Charset.forName("ISO-8859-1").newEncoder().onUnmappableCharacter(CodingErrorAction.REPORT);
        byte[] bytes = encoder.encode(CharBuffer.wrap(propFileText)).array();
        Properties props = new Properties();
        try {
            props.load(new ByteArrayInputStream(bytes));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return props;
    }

    public static Reader getInputStreamReader(InputStream in) {
        return StreamUtil.getInputStreamReader(in, "UTF-8");
    }

    public static Reader getInputStreamReader(InputStream in, String charset) {
        try {
            return new InputStreamReader(in, charset);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Writer getOutputStreamWriter(OutputStream out) {
        try {
            return new OutputStreamWriter(out, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static InputStream getStringInputStream(CharSequence cs) {
        return new ByteArrayInputStream(StreamUtil.toBytes(cs));
    }

    public static byte[] getContent(InputStream in) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamUtil.copy(in, (OutputStream)baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            in.close();
        }
    }

    public static String getContent(Reader in) throws IOException {
        try {
            StringWriter sw = new StringWriter();
            StreamUtil.copy(in, (Writer)sw);
            String string = sw.toString();
            return string;
        }
        finally {
            in.close();
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int count;
        byte[] buf = new byte[1024];
        while ((count = in.read(buf)) >= 0) {
            out.write(buf, 0, count);
        }
        out.flush();
    }

    public static void copy(InputStream in, Writer writer) throws IOException {
        StreamUtil.copy(StreamUtil.getInputStreamReader(in), writer);
        writer.flush();
    }

    public static void copy(Reader reader, OutputStream out) throws IOException {
        StreamUtil.copy(reader, StreamUtil.getOutputStreamWriter(out));
        out.flush();
    }

    public static void copy(Reader in, Writer out) throws IOException {
        int count;
        char[] buf = new char[1024];
        while ((count = in.read(buf)) >= 0) {
            out.write(buf, 0, count);
        }
        out.flush();
    }

    public static void closeNoThrow(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Closeable ... streams) throws IOException {
        StreamUtil.close(streams, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void close(Closeable[] streams, int idx) throws IOException {
        if (idx >= streams.length) {
            return;
        }
        Closeable stream = streams[idx];
        try {
            if (stream != null) {
                if (stream instanceof Flushable) {
                    ((Flushable)((Object)stream)).flush();
                }
                stream.close();
            }
        }
        catch (IOException ex) {
            if (!(stream instanceof InputStream) && !(stream instanceof Reader)) {
                throw ex;
            }
        }
        finally {
            StreamUtil.close(streams, idx + 1);
        }
    }
}

