/*
 * Decompiled with CFR 0.152.
 */
package gw.fs.physical.win32;

import gw.fs.ResourcePath;
import gw.fs.physical.IFileMetadata;
import gw.fs.physical.IPhysicalFileSystem;
import gw.fs.physical.generic.GenericFileMetadata;
import gw.fs.physical.win32.NativeWin32API;
import gw.fs.physical.win32.Win32FileMetadata;
import gw.fs.physical.win32.Win32FindData;
import gw.lang.UnstableAPI;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

@UnstableAPI
public class Win32PhysicalFileSystem
implements IPhysicalFileSystem {
    @Override
    public List<? extends IFileMetadata> listFiles(ResourcePath directoryPath) {
        List<Win32FindData> findDatas = NativeWin32API.listDir(directoryPath.getFileSystemPathString());
        ArrayList<Win32FileMetadata> fileMD = new ArrayList<Win32FileMetadata>();
        for (Win32FindData findData : findDatas) {
            fileMD.add(new Win32FileMetadata(findData));
        }
        return fileMD;
    }

    @Override
    public IFileMetadata getFileMetadata(ResourcePath filePath) {
        Win32FindData findData = NativeWin32API.fileMetadata(filePath.getFileSystemPathString());
        if (findData != null) {
            return new Win32FileMetadata(findData);
        }
        return new GenericFileMetadata(this.toJavaFile(filePath));
    }

    @Override
    public boolean exists(ResourcePath filePath) {
        return this.toJavaFile(filePath).exists();
    }

    @Override
    public boolean delete(ResourcePath filePath) {
        return this.toJavaFile(filePath).delete();
    }

    @Override
    public boolean mkdir(ResourcePath dirPath) {
        return this.toJavaFile(dirPath).mkdir();
    }

    @Override
    public void clearDirectoryCaches(ResourcePath dirPath) {
    }

    @Override
    public void clearAllCaches() {
    }

    private File toJavaFile(ResourcePath directoryPath) {
        return new File(directoryPath.getFileSystemPathString());
    }
}

