/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.gosuc;

import gw.lang.gosuc.ICustomParser;

public class GosucArg {
    public static final GosucArg PROJECT = new GosucArg(true, false, "-project", "The GosuC project file to compile");
    public static final GosucArg PARSER = new GosucArg(false, false, "-parser", "The fully qualified name of a custom parser class implementing " + ICustomParser.class.getName());
    public static final GosucArg[] ARGS = new GosucArg[]{PROJECT, PARSER};
    private String _name;
    private String _value;
    private String _desc;
    private boolean _bRequired;
    private boolean _bFlag;
    private boolean _bMatched;
    private String _error;

    public GosucArg(boolean bRequired, boolean bFlag, String name, String desc) {
        this._bRequired = bRequired;
        this._bFlag = bFlag;
        this._name = name;
        this._desc = desc;
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        this._value = value;
    }

    public boolean isRequired() {
        return this._bRequired;
    }

    public boolean isFlag() {
        return this._bFlag;
    }

    public String getDescription() {
        return this._desc;
    }

    public boolean isMatched() {
        return this._bMatched;
    }

    void setMatched(boolean bMatched) {
        this._bMatched = bMatched;
    }

    public String getError() {
        return this._error;
    }

    public void setError(String error) {
        this._error = error;
    }

    public boolean hasError() {
        return this.getError() != null;
    }

    public String toString() {
        return this._name + " = " + this._value;
    }

    private int match(String[] args) {
        if (args.length < 1) {
            return 0;
        }
        if (this.getName().equalsIgnoreCase(args[0])) {
            if (this.isMatched()) {
                this.setError("Multiple " + this.getName() + " arguments are not supported.");
                return 1;
            }
            this.setMatched(true);
            if (!this.isFlag()) {
                if (args.length == 1 || args[1].length() == 0) {
                    this.setError("Expecting a value for " + this.getName());
                    return 1;
                }
                this.setValue(args[1]);
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public static String parseArgs(String[] args) {
        if (args.length == 0) {
            return "Expecting arguments: " + PROJECT.getName() + " <" + PROJECT.getDescription() + ">";
        }
        for (int i = 0; i < args.length; ++i) {
            int iPos = i;
            GosucArg[] gosucArgArray = ARGS;
            int n = gosucArgArray.length;
            for (int j = 0; j < n; ++j) {
                GosucArg arg = gosucArgArray[j];
                String[] csr = new String[args.length - i];
                System.arraycopy(args, i, csr, 0, csr.length);
                i += arg.match(csr);
            }
            if (i != iPos) continue;
            return "Unknow arguments starting at " + args[i];
        }
        String errors = "";
        for (GosucArg arg : ARGS) {
            if (!arg.hasError()) continue;
            errors = errors + arg.getError() + "\n";
        }
        return errors.isEmpty() ? null : errors;
    }
}

