/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.gosuc;

import gw.lang.gosuc.GosucProject;
import gw.lang.gosuc.ICustomParser;
import gw.lang.parser.ISourceCodeTokenizer;
import gw.util.StreamUtil;
import java.io.IOException;
import java.io.InputStream;

public class GosucProjectParser {
    private ISourceCodeTokenizer _tokenizer;

    public static GosucProject parse(InputStream file, ICustomParser custParser) {
        String strContent;
        if (file == null) {
            return null;
        }
        try {
            strContent = StreamUtil.getContent(StreamUtil.getInputStreamReader(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return GosucProjectParser.parse(strContent, custParser);
    }

    public static GosucProject parse(String strContent, ICustomParser custParser) {
        if (strContent == null || strContent.length() == 0) {
            return null;
        }
        GosucProjectParser parser = new GosucProjectParser(strContent);
        parser.initTokenizer();
        return GosucProject.parse(parser, custParser);
    }

    private GosucProjectParser(String strContent) {
        this._tokenizer = this.makeTokenizer(strContent);
        this._tokenizer.wordChars(95, 95);
        this._tokenizer.wordChars(45, 45);
        this._tokenizer.setSupportsKeywords(false);
    }

    private ISourceCodeTokenizer makeTokenizer(String strContent) {
        try {
            Class<?> srcCodeTokenizerClass = Class.forName("gw.internal.gosu.parser.SourceCodeTokenizer");
            return (ISourceCodeTokenizer)srcCodeTokenizerClass.getConstructor(CharSequence.class).newInstance(strContent);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ISourceCodeTokenizer getTokenizer() {
        return this._tokenizer;
    }

    private void initTokenizer() {
        this._tokenizer.nextToken();
    }

    public boolean matchWord(String word, boolean bPeek) {
        return this.match(word, -5, bPeek) || this.match(word, -7, bPeek);
    }

    public boolean matchOperator(String token, boolean bPeek) {
        boolean bMatch;
        boolean bl = bMatch = this._tokenizer.getType() == -6 && token.equalsIgnoreCase(this._tokenizer.getStringValue());
        if (bMatch && !bPeek) {
            this._tokenizer.nextToken();
        }
        return bMatch;
    }

    public boolean match(String token, int iType, boolean bPeek) {
        boolean bMatch = false;
        if (token != null) {
            if (iType == this._tokenizer.getType() || iType == 0 && this._tokenizer.getType() == -5) {
                bMatch = token.equalsIgnoreCase(this._tokenizer.getStringValue());
            }
        } else {
            boolean bl = bMatch = this._tokenizer.getType() == iType;
        }
        if (bMatch && !bPeek) {
            this._tokenizer.nextToken();
        }
        return bMatch;
    }

    public void verify(boolean bAssertion, String errorMsg) {
        if (!bAssertion) {
            throw new IllegalStateException("Gosuc Project Parsing Error on Line: " + this._tokenizer.getLineNumber() + "\n" + errorMsg);
        }
    }
}

