/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.ir.statement;

import gw.internal.ext.org.objectweb.asm.signature.SignatureVisitor;
import gw.internal.ext.org.objectweb.asm.signature.SignatureWriter;
import gw.lang.UnstableAPI;
import gw.lang.ir.IRAnnotation;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.IRType;
import gw.lang.ir.SignatureUtil;
import gw.lang.ir.statement.IRTerminalStatement;
import gw.lang.reflect.ICompoundType;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.lang.reflect.java.JavaTypes;
import gw.util.GosuStringUtil;
import java.util.Collections;
import java.util.List;

@UnstableAPI
public class IRMethodStatement
extends IRStatement {
    private IRStatement _methodBody;
    private String _name;
    private int _modifiers;
    private List<IRSymbol> _parameters;
    private IRType _returnType;
    private List<IRAnnotation> _annotations;
    private boolean _explicitInternal;
    private Object[] _annotationDefault;
    private String _genericSignature;

    public IRMethodStatement(IRStatement methodBody, String name, int modifiers, boolean explicitInternal, IRType returnType, List<IRSymbol> parameters) {
        this(methodBody, name, modifiers, explicitInternal, returnType, parameters, null);
    }

    public IRMethodStatement(IRStatement methodBody, String name, int modifiers, boolean explicitInternal, IRType returnType, List<IRSymbol> parameters, Object[] annotationDefault) {
        this(methodBody, name, modifiers, explicitInternal, returnType, null, parameters, null, null, annotationDefault);
    }

    public IRMethodStatement(IRStatement methodBody, String name, int modifiers, boolean explicitInternal, IRType returnType, IType returnIType, List<IRSymbol> parameters, IType[] argTypes, IType methodType, Object[] annotationDefault) {
        this._methodBody = methodBody;
        this._name = name;
        this._modifiers = modifiers;
        this._explicitInternal = explicitInternal;
        this._returnType = IRMethodStatement.maybeEraseStructuralType(returnType);
        this._parameters = this.maybeEraseStructuralSymbolTypes(parameters);
        this._annotations = Collections.emptyList();
        this.setParentToThis(methodBody);
        this._annotationDefault = annotationDefault;
        this._genericSignature = this.makeGenericSignature(methodType, returnIType, argTypes);
    }

    private String makeGenericSignature(IType type, IType rtype, IType[] args) {
        if (type == null || rtype == null || args == null) {
            return null;
        }
        boolean[] bGeneric = new boolean[]{false};
        SignatureWriter sw = new SignatureWriter();
        if (type.isGenericType()) {
            bGeneric[0] = true;
            for (IGenericTypeVariable tv : type.getGenericTypeVariables()) {
                sw.visitFormalTypeParameter(tv.getName());
                IType boundingType = tv.getBoundingType();
                if (boundingType != null) {
                    IType[] types = boundingType instanceof ICompoundType ? ((ICompoundType)boundingType).getTypes().toArray(new IType[0]) : new IType[]{boundingType};
                    for (int i = types.length - 1; i >= 0; --i) {
                        SignatureVisitor sv = types[i].isInterface() ? sw.visitInterfaceBound() : sw.visitClassBound();
                        SignatureUtil.visitType(sv, SignatureUtil.getPureGenericType(types[i]), bGeneric);
                    }
                    continue;
                }
                SignatureVisitor sv = sw.visitClassBound();
                SignatureUtil.visitType(sv, JavaTypes.OBJECT(), bGeneric);
            }
        }
        SignatureVisitor sv = sw.visitParameterType();
        for (IType arg : args) {
            SignatureUtil.visitType(sv, arg, bGeneric);
        }
        sv = sw.visitReturnType();
        SignatureUtil.visitType(sv, rtype, bGeneric);
        if (bGeneric[0]) {
            return sw.toString();
        }
        return null;
    }

    public IRStatement getMethodBody() {
        return this._methodBody;
    }

    public String getName() {
        return this._name;
    }

    public int getModifiers() {
        return this._modifiers;
    }

    public List<IRSymbol> getParameters() {
        return this._parameters;
    }

    public IRType getReturnType() {
        return this._returnType;
    }

    @Override
    public IRTerminalStatement getLeastSignificantTerminalStatement() {
        return null;
    }

    public String toString() {
        return this.signature();
    }

    public String signature() {
        return this._name + "(" + GosuStringUtil.join(this._parameters, ", ") + "):" + this._returnType;
    }

    public void setAnnotations(List<IRAnnotation> irAnnotations) {
        this._annotations = irAnnotations;
    }

    public List<IRAnnotation> getAnnotations() {
        return this._annotations;
    }

    public Object[] getAnnotationDefault() {
        return this._annotationDefault;
    }

    public String getGenericSignature() {
        return this._genericSignature;
    }

    public boolean isExplicitInternal() {
        return this._explicitInternal;
    }
}

