/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.ir.statement;

import gw.lang.UnstableAPI;
import gw.lang.ir.IRStatement;
import gw.lang.ir.statement.IRCatchClause;
import gw.lang.ir.statement.IRTerminalStatement;
import java.util.List;

@UnstableAPI
public class IRTryCatchFinallyStatement
extends IRStatement {
    private IRStatement _tryBody;
    private List<IRCatchClause> _catchStatements;
    private IRStatement _finallyBody;

    public IRTryCatchFinallyStatement(IRStatement tryBody, List<IRCatchClause> catchStatements, IRStatement finallyBody) {
        this._tryBody = tryBody;
        this._catchStatements = catchStatements;
        this._finallyBody = finallyBody;
        tryBody.setParent(this);
        for (IRCatchClause catchClause : catchStatements) {
            catchClause.getBody().setParent(this);
        }
        if (finallyBody != null) {
            finallyBody.setParent(this);
        }
    }

    public IRStatement getTryBody() {
        return this._tryBody;
    }

    public List<IRCatchClause> getCatchStatements() {
        return this._catchStatements;
    }

    public IRStatement getFinallyBody() {
        return this._finallyBody;
    }

    @Override
    public IRTerminalStatement getLeastSignificantTerminalStatement() {
        IRTerminalStatement tryStmtTerminal = this._tryBody.getLeastSignificantTerminalStatement();
        if (tryStmtTerminal != null) {
            if (this._catchStatements.isEmpty()) {
                return tryStmtTerminal;
            }
            IRTerminalStatement catchStmtTerminal = this._catchStatements.get(this._catchStatements.size() - 1).getBody().getLeastSignificantTerminalStatement();
            if (catchStmtTerminal != null) {
                return catchStmtTerminal;
            }
        }
        return null;
    }
}

