/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.config.CommonServices;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.MethodList;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuObject;
import gw.util.GosuStringUtil;
import java.lang.reflect.Method;
import java.util.List;

public class ReflectUtil {
    public static <T> T construct(String typeName, Object ... args) {
        IType type = TypeSystem.getByFullName(typeName);
        ReflectUtil.ensureTypeIsValid(type);
        Object[] runtimeTypes = ReflectUtil.extractRuntimeTypes(args);
        IConstructorInfo constructorInfo = ReflectUtil.findCallableConstructor(type, (IType[])runtimeTypes);
        if (constructorInfo != null) {
            return (T)constructorInfo.getConstructor().newInstance(ReflectUtil.coerceArgsIfNecessary(constructorInfo.getParameters(), args));
        }
        throw new IllegalArgumentException("Unable to find a constructor on " + type.getName() + " with parameters compatible with arg types [" + GosuStringUtil.join(runtimeTypes, ",") + "]");
    }

    public static IGosuObject constructGosuClassInstance(String className, Object ... args) {
        return (IGosuObject)ReflectUtil.construct(className, args);
    }

    public static Object invokeStaticMethod(String className, String methodName, Object ... args) {
        IType type = TypeSystem.getByFullName(className);
        ReflectUtil.ensureTypeIsValid(type);
        Object[] runtimeTypes = ReflectUtil.extractRuntimeTypes(args);
        IMethodInfo info = ReflectUtil.findCallableMethod(methodName, (IType[])runtimeTypes, type);
        if (info != null && info.isStatic()) {
            return info.getCallHandler().handleCall(type, ReflectUtil.coerceArgsIfNecessary(info.getParameters(), args));
        }
        throw new IllegalArgumentException("Unable to find a static method on " + type.getName() + " with name " + methodName + " and parameters compatible with arg types [" + GosuStringUtil.join(runtimeTypes, ",") + "]");
    }

    public static void setStaticProperty(String className, String propertyName, Object value) {
        IType type = TypeSystem.getByFullName(className);
        ReflectUtil.setStaticProperty(type, propertyName, value);
    }

    public static void setStaticProperty(IType type, String propertyName, Object value) {
        ReflectUtil.ensureTypeIsValid(type);
        IPropertyInfo propertyInfo = ReflectUtil.findProperty(type, propertyName);
        if (propertyInfo == null || !propertyInfo.isStatic()) {
            throw new IllegalArgumentException("Unable to find a static property on " + type.getName() + " with name " + propertyName);
        }
        IType iType = propertyInfo.getFeatureType();
        propertyInfo.getAccessor().setValue(type, ReflectUtil.coerce(value, iType));
    }

    public static Object getStaticProperty(String className, String propertyName) {
        IType type = TypeSystem.getByFullName(className);
        return ReflectUtil.getStaticProperty(type, propertyName);
    }

    public static Object getStaticProperty(IType type, String propertyName) {
        ReflectUtil.ensureTypeIsValid(type);
        IPropertyInfo propertyInfo = ReflectUtil.findProperty(type, propertyName);
        if (propertyInfo != null && propertyInfo.isStatic()) {
            return propertyInfo.getAccessor().getValue(type);
        }
        throw new IllegalArgumentException("Unable to find a static property on " + type.getName() + " with name " + propertyName);
    }

    public static Object invokeMethod(Object instance, String methodName, Object ... args) {
        IType type;
        Object[] runtimeTypes = ReflectUtil.extractRuntimeTypes(args);
        IMethodInfo methodInfo = ReflectUtil.findCallableMethod(methodName, (IType[])runtimeTypes, type = TypeSystem.getFromObject(instance));
        if (methodInfo != null) {
            return methodInfo.getCallHandler().handleCall(instance, ReflectUtil.coerceArgsIfNecessary(methodInfo.getParameters(), args));
        }
        throw new IllegalArgumentException("Unable to find a method on " + type.getName() + " with name " + methodName + " and parameters compatible with arg types [" + GosuStringUtil.join(runtimeTypes, ",") + "]");
    }

    public static void setProperty(Object instance, String propertyName, Object value) {
        IType type = TypeSystem.getFromObject(instance);
        IPropertyInfo propertyInfo = ReflectUtil.findProperty(type, propertyName);
        if (propertyInfo == null) {
            throw new IllegalArgumentException("Unable to find a property on " + type.getName() + " with name " + propertyName);
        }
        propertyInfo.getAccessor().setValue(instance, ReflectUtil.coerce(value, propertyInfo.getFeatureType()));
    }

    public static Object getProperty(Object instance, String propertyName) {
        IType type = TypeSystem.getFromObject(instance);
        IPropertyInfo propertyInfo = ReflectUtil.findProperty(type, propertyName);
        if (propertyInfo != null) {
            return propertyInfo.getAccessor().getValue(instance);
        }
        throw new IllegalArgumentException("Unable to find a property on " + type.getName() + " with name " + propertyName);
    }

    public static IGosuClass getClass(String fullyQualifiedName) {
        return (IGosuClass)TypeSystem.getByFullName(fullyQualifiedName);
    }

    public static IGosuClass getClassButThrowIfInvalid(String fullyQualifiedName) {
        IGosuClass gosuClass = ReflectUtil.getClass(fullyQualifiedName);
        if (!gosuClass.isValid()) {
            throw new RuntimeException(gosuClass.getParseResultsException());
        }
        return gosuClass;
    }

    public static Object[] coerceArgsIfNecessary(IParameterInfo[] parameters, Object ... args) {
        for (int i = 0; i < parameters.length; ++i) {
            args[i] = ReflectUtil.coerce(args[i], parameters[i].getFeatureType());
        }
        return args;
    }

    public static IPropertyInfo findProperty(IType type, String propertyName) {
        ITypeInfo typeInfo = type.getTypeInfo();
        return typeInfo instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)typeInfo).getProperty(type, propertyName) : typeInfo.getProperty(propertyName);
    }

    public static IMethodInfo findCallableMethod(String methodName, IType[] runtimeTypes, IType type) {
        ITypeInfo typeInfo = type.getTypeInfo();
        MethodList methodInfos = typeInfo instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)typeInfo).getMethods(type) : typeInfo.getMethods();
        return ITypeInfo.FIND.callableMethod(methodInfos, methodName, runtimeTypes);
    }

    private static IConstructorInfo findCallableConstructor(IType type, IType[] runtimeTypes) {
        ITypeInfo typeInfo = type.getTypeInfo();
        List<? extends IConstructorInfo> constructors = typeInfo instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)typeInfo).getConstructors(type) : typeInfo.getConstructors();
        return ITypeInfo.FIND.callableConstructor(constructors, runtimeTypes);
    }

    private static void ensureTypeIsValid(IType type) {
        if (!type.isValid()) {
            if (type instanceof IGosuClass) {
                throw new IllegalArgumentException("The type " + type.getName() + " is invalid", ((IGosuClass)type).getParseResultsException());
            }
            throw new IllegalArgumentException("The type " + type.getName() + " is invalid");
        }
    }

    public static IType[] extractRuntimeTypes(Object ... args) {
        IType[] runtimeTypes = new IType[args.length];
        for (int i = 0; i < args.length; ++i) {
            runtimeTypes[i] = TypeSystem.getFromObject(args[i]);
        }
        return runtimeTypes;
    }

    public static Object coerce(Object value, IType iType) {
        return CommonServices.getCoercionManager().convertValue(value, iType);
    }

    public static IGosuObject getEnclosingClassInstance(IGosuObject obj) {
        Class<?> cls = obj.getClass();
        IGosuObject outer = null;
        while (Modifier.isStatic(cls.getModifiers()) && cls.getEnclosingClass() != null) {
            try {
                Method m = cls.getDeclaredMethod("access$0", obj.getClass());
                m.setAccessible(true);
                obj = outer = (IGosuObject)m.invoke(null, obj);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            cls = outer.getClass();
        }
        return outer;
    }
}

