/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.features;

import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.features.FeatureReference;
import gw.lang.reflect.features.IFeatureChain;
import gw.lang.reflect.features.IFeatureReference;
import gw.lang.reflect.features.IPropertyReference;
import gw.lang.reflect.features.PropertyReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class BoundPropertyChainReference<R, T>
extends FeatureReference<R, T>
implements IPropertyReference<R, T>,
IFeatureChain {
    private FeatureReference _root;
    private IType _rootType;
    private IPropertyInfo _pi;

    public BoundPropertyChainReference(IType rootType, FeatureReference root, String property) {
        this._rootType = rootType;
        this._pi = PropertyReference.getPropertyInfo(rootType, property);
        this._root = root;
    }

    public T get() {
        Object fromRoot = this._root.evaluate(Collections.singleton(null).iterator());
        return (T)this.getPropertyInfo().getAccessor().getValue(fromRoot);
    }

    public void set(T val) {
        Object fromRoot = this._root.evaluate(Collections.singleton(null).iterator());
        this.getPropertyInfo().getAccessor().setValue(fromRoot, val);
    }

    @Override
    public IType getRootType() {
        return this._rootType;
    }

    @Override
    public IFeatureInfo getFeatureInfo() {
        return this.getPropertyInfo();
    }

    @Override
    protected Object evaluate(Iterator args) {
        Object ctx = this._root.evaluate(args);
        return this._pi.getAccessor().getValue(ctx);
    }

    @Override
    protected List<IType> getFullArgTypes() {
        return this._root.getFullArgTypes();
    }

    @Override
    public IPropertyInfo getPropertyInfo() {
        return this._pi;
    }

    @Override
    public IFeatureReference getRootFeatureReference() {
        return this._root;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundPropertyChainReference that = (BoundPropertyChainReference)o;
        if (this._pi != null ? !this._pi.equals(that._pi) : that._pi != null) {
            return false;
        }
        if (this._root != null ? !this._root.equals(that._root) : that._root != null) {
            return false;
        }
        return !(this._rootType != null ? !this._rootType.equals(that._rootType) : that._rootType != null);
    }

    public int hashCode() {
        int result = this._root != null ? this._root.hashCode() : 0;
        result = 31 * result + (this._rootType != null ? this._rootType.hashCode() : 0);
        result = 31 * result + (this._pi != null ? this._pi.hashCode() : 0);
        return result;
    }
}

