/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.gs;

import gw.fs.IDirectory;
import gw.lang.GosuShop;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.ITypeUsesMap;
import gw.lang.reflect.FragmentCache;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeLoader;
import gw.lang.reflect.RefreshKind;
import gw.lang.reflect.RefreshRequest;
import gw.lang.reflect.SimpleTypeLoader;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.ICompilableType;
import gw.lang.reflect.gs.IEnhancementIndex;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuClassRepository;
import gw.lang.reflect.gs.IGosuFragment;
import gw.lang.reflect.gs.ISourceFileHandle;
import gw.lang.reflect.gs.TypeName;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.module.IModule;
import gw.util.concurrent.LockingLazyVar;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GosuClassTypeLoader
extends SimpleTypeLoader {
    public static final String GOSU_CLASS_FILE_EXT = ".gs";
    public static final String GOSU_ENHANCEMENT_FILE_EXT = ".gsx";
    public static final String GOSU_PROGRAM_FILE_EXT = ".gsp";
    public static final String GOSU_TEMPLATE_FILE_EXT = ".gst";
    public static final String GOSU_RULE_EXT = ".gr";
    public static final String GOSU_RULE_SET_EXT = ".grs";
    public static final String[] ALL_EXTS = new String[]{".gs", ".gsx", ".gsp", ".gst", ".gr", ".grs"};
    public static final Set<String> ALL_EXTS_SET = new HashSet<String>(Arrays.asList(".gs", ".gsx", ".gsp", ".gst", ".gr", ".grs"));
    public static final Set<String> EXTENSIONS = new HashSet<String>(Arrays.asList("gs", "gsx", "gsp", "gst", "gr", "grs"));
    public static final String BLOCK_PREFIX = "block_";
    public static final String INNER_BLOCK_PREFIX = ".block_";
    public static final String BLOCK_POSTFIX = "_";
    private IGosuClassRepository _repository;
    private LockingLazyVar<IEnhancementIndex> _enhancementIndex;
    protected Set<String> _namespaces;

    public static GosuClassTypeLoader getDefaultClassLoader() {
        return TypeSystem.getTypeLoader(GosuClassTypeLoader.class);
    }

    public static GosuClassTypeLoader getDefaultClassLoader(IModule module) {
        return TypeSystem.getTypeLoader(GosuClassTypeLoader.class, module);
    }

    public GosuClassTypeLoader(IGosuClassRepository repository) {
        this(repository.getModule(), repository);
    }

    public GosuClassTypeLoader(IModule module, IGosuClassRepository repository) {
        super(module);
        this._repository = repository;
        this.makeEnhancementIndex();
    }

    private void makeEnhancementIndex() {
        this._enhancementIndex = new LockingLazyVar<IEnhancementIndex>(){
            private boolean _initializing;

            @Override
            protected IEnhancementIndex init() {
                if (this._initializing) {
                    return null;
                }
                this._initializing = true;
                IEnhancementIndex index = GosuShop.createEnhancementIndex(GosuClassTypeLoader.this);
                index.maybeLoadEnhancementIndex();
                return index;
            }
        };
    }

    public IGosuClassRepository getRepository() {
        return this._repository;
    }

    public IEnhancementIndex getEnhancementIndex() {
        return this._enhancementIndex.get();
    }

    @Override
    public boolean isCaseSensitive() {
        return true;
    }

    @Override
    public ICompilableType getType(String strFullyQualifiedName) {
        ITypeLoader typeLoader;
        IGosuFragment fragment;
        IGosuClass adapterClass;
        this._enhancementIndex.get();
        int iDollar = strFullyQualifiedName.indexOf(36);
        if (iDollar > 0) {
            IType topLevelType = TypeSystem.getByFullNameIfValid(strFullyQualifiedName.substring(0, iDollar));
            if (topLevelType instanceof IGosuClass) {
                strFullyQualifiedName = strFullyQualifiedName.replace('$', '.');
            } else if (topLevelType != null) {
                return null;
            }
        }
        if ((adapterClass = this.getAdapterClass(strFullyQualifiedName)) != null) {
            return adapterClass;
        }
        if (!this.isBlock(strFullyQualifiedName) && (fragment = FragmentCache.instance().get(strFullyQualifiedName)) != null) {
            return fragment;
        }
        IType type = TypeSystem.getCompilingType(strFullyQualifiedName);
        ITypeLoader iTypeLoader = typeLoader = type != null ? type.getTypeLoader() : null;
        if (type != null && typeLoader != this) {
            return null;
        }
        if (type == null) {
            return this.findClass(strFullyQualifiedName);
        }
        return (IGosuClass)type;
    }

    private IGosuClass getAdapterClass(String strFullyQualifiedName) {
        IType javaType;
        if (this.getClass() == GosuClassTypeLoader.class && strFullyQualifiedName.length() > "_proxy_".length() && strFullyQualifiedName.startsWith("_proxy_") && (javaType = TypeSystem.getByFullNameIfValid(IGosuClass.ProxyUtil.getNameSansProxy(strFullyQualifiedName))) instanceof IJavaType) {
            IGosuClass adapterClass = ((IJavaType)javaType).getAdapterClass();
            if (adapterClass == null) {
                adapterClass = ((IJavaType)javaType).createAdapterClass();
            }
            return adapterClass;
        }
        return null;
    }

    public Set<String> getAllNamespaces() {
        if (this._namespaces == null) {
            try {
                this._namespaces = TypeSystem.getNamespacesFromTypeNames(this.getAllTypeNames(), new HashSet<String>());
                this._namespaces.add("Libraries");
            }
            catch (NullPointerException e) {
                return Collections.emptySet();
            }
        }
        return this._namespaces;
    }

    @Override
    public void refreshedNamespace(String namespace, IDirectory dir, RefreshKind kind) {
        if (this._namespaces != null) {
            if (kind == RefreshKind.CREATION) {
                this._namespaces.add(namespace);
            } else if (kind == RefreshKind.DELETION) {
                this._namespaces.remove(namespace);
            }
        }
        this._repository.namespaceRefreshed(namespace, dir, kind);
    }

    @Override
    public URL getResource(String name) {
        return this._repository.findResource(name);
    }

    @Override
    public Set<String> computeTypeNames() {
        return this._repository.getAllTypeNames(this.getAllExtensions());
    }

    @Override
    public void refreshedImpl() {
        this._namespaces = null;
        this._repository.typesRefreshed(null);
    }

    @Override
    public List<String> getHandledPrefixes() {
        return Collections.emptyList();
    }

    @Override
    public boolean handlesNonPrefixLoads() {
        return true;
    }

    public IGosuClass makeNewClass(ISourceFileHandle sourceFile) {
        return this.makeNewClass(sourceFile, null);
    }

    public IGosuClass makeNewClass(ISourceFileHandle sourceFile, ISymbolTable programSymTable) {
        switch (sourceFile.getClassType()) {
            case Class: 
            case Interface: 
            case Annotation: 
            case Structure: 
            case Enum: {
                return GosuShop.createClass(sourceFile.getTypeNamespace(), sourceFile.getRelativeName(), this, sourceFile, this.getTypeUsesMap());
            }
            case Enhancement: {
                return GosuShop.createEnhancement(sourceFile.getTypeNamespace(), sourceFile.getRelativeName(), this, sourceFile, this.getTypeUsesMap());
            }
            case Program: {
                return GosuShop.createProgram(sourceFile.getTypeNamespace(), sourceFile.getRelativeName(), this, sourceFile, this.getTypeUsesMap(), programSymTable);
            }
            case Template: {
                return GosuShop.createTemplate(sourceFile.getTypeNamespace(), sourceFile.getRelativeName(), this, sourceFile, this.getTypeUsesMap(), programSymTable);
            }
            case Eval: {
                return GosuShop.createProgramForEval(sourceFile.getTypeNamespace(), sourceFile.getRelativeName(), this, sourceFile, this.getTypeUsesMap(), programSymTable);
            }
        }
        throw new IllegalStateException("Unhandled class type: " + (Object)((Object)sourceFile.getClassType()));
    }

    private IGosuClass getBlockType(String strName) {
        IGosuClass classInternal = null;
        if (this.isBlock(strName)) {
            try {
                String strippedName = strName.substring(0, strName.length() - BLOCK_POSTFIX.length());
                int iStr = strippedName.lastIndexOf(INNER_BLOCK_PREFIX);
                String indexStr = strippedName.substring(iStr + INNER_BLOCK_PREFIX.length(), strippedName.length());
                int i = Integer.parseInt(indexStr);
                String enclosingClassStr = strippedName.substring(0, iStr);
                IType type = this.getBlockType(enclosingClassStr);
                if (type == null) {
                    type = TypeSystem.getByFullNameIfValid(enclosingClassStr.replace('$', '.'), this.getModule());
                }
                if (type instanceof ICompilableType && type.getTypeLoader().getModule() == this._module) {
                    classInternal = ((ICompilableType)type).getBlock(i);
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return classInternal;
    }

    private boolean isBlock(String strName) {
        return strName.endsWith(BLOCK_POSTFIX) && strName.contains(INNER_BLOCK_PREFIX);
    }

    private IGosuClass findClass(String strQualifiedClassName) {
        IGosuClass blockType = this.getBlockType(strQualifiedClassName);
        if (blockType != null) {
            return blockType;
        }
        ISourceFileHandle sourceFile = this._repository.findClass(strQualifiedClassName, this.getAllExtensions());
        if (!(sourceFile != null && this.isValidSourceFileHandle(sourceFile) && sourceFile.isValid() && strQualifiedClassName.endsWith(sourceFile.getRelativeName()))) {
            return null;
        }
        IGosuClass gsClass = null;
        if (sourceFile.getParentType() != null) {
            IType type = TypeSystem.getByFullNameIfValid(sourceFile.getParentType());
            if (type instanceof IGosuClass) {
                IGosuClass enclosingType = (IGosuClass)type;
                gsClass = enclosingType.getInnerClass(sourceFile.getRelativeName());
            }
        } else {
            gsClass = this.makeNewClass(sourceFile);
        }
        return gsClass;
    }

    protected boolean isValidSourceFileHandle(ISourceFileHandle sourceFile) {
        return sourceFile.getClassType().isGosu();
    }

    protected String[] getAllExtensions() {
        return ALL_EXTS;
    }

    protected ITypeUsesMap getTypeUsesMap() {
        return null;
    }

    @Override
    public void refreshedTypesImpl(RefreshRequest request) {
        this._repository.typesRefreshed(request);
        this._enhancementIndex.get().refreshedTypes(request);
    }

    public boolean shouldKeepDebugInfo(IGosuClass gsClass) {
        return gsClass.shouldKeepDebugInfo();
    }

    @Override
    public Set<String> getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public Set<TypeName> getTypeNames(String namespace) {
        return this._repository.getTypeNames(namespace, ALL_EXTS_SET, this);
    }

    @Override
    public boolean hasNamespace(String namespace) {
        return this._repository.hasNamespace(namespace) > 0;
    }
}

