/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.interval;

import gw.lang.reflect.interval.NumberInterval;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class BigIntegerInterval
extends NumberInterval<BigInteger, BigIntegerInterval> {
    public BigIntegerInterval(BigInteger left, BigInteger right) {
        this(left, right, BigInteger.ONE, true, true, false);
    }

    public BigIntegerInterval(BigInteger left, BigInteger right, BigInteger step, boolean bLeftClosed, boolean bRightClosed, boolean bReverse) {
        super(left, right, step, bLeftClosed, bRightClosed, bReverse);
        if (step.compareTo(BigInteger.ZERO) <= 0) {
            throw new IllegalArgumentException("The step must be greater than 0: " + step);
        }
    }

    @Override
    public Iterator<BigInteger> iterateFromLeft() {
        return new ForwardIterator();
    }

    @Override
    public Iterator<BigInteger> iterateFromRight() {
        return new ReverseIterator();
    }

    @Override
    public BigInteger getFromLeft(int iStepIndex) {
        if (iStepIndex < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + iStepIndex);
        }
        if (!this.isLeftClosed()) {
            ++iStepIndex;
        }
        BigInteger value = ((BigInteger)this.getLeftEndpoint()).add(((BigInteger)this.getStep()).multiply(BigInteger.valueOf(iStepIndex)));
        int iComp = value.compareTo((BigInteger)this.getRightEndpoint());
        if (this.isRightClosed() ? iComp <= 0 : iComp < 0) {
            return value;
        }
        return null;
    }

    @Override
    public BigInteger getFromRight(int iStepIndex) {
        if (iStepIndex < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + iStepIndex);
        }
        if (!this.isRightClosed()) {
            ++iStepIndex;
        }
        BigInteger value = ((BigInteger)this.getRightEndpoint()).subtract(((BigInteger)this.getStep()).multiply(BigInteger.valueOf(iStepIndex)));
        int iComp = value.compareTo((BigInteger)this.getLeftEndpoint());
        if (this.isLeftClosed() ? iComp >= 0 : iComp > 0) {
            return value;
        }
        return null;
    }

    private class ReverseIterator
    implements Iterator<BigInteger> {
        private BigInteger _csr;

        public ReverseIterator() {
            this._csr = (BigInteger)BigIntegerInterval.this.getRightEndpoint();
            if (!BigIntegerInterval.this.isRightClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            int iComp = this._csr.compareTo((BigInteger)BigIntegerInterval.this.getLeftEndpoint());
            return iComp > 0 || BigIntegerInterval.this.isLeftClosed() && iComp == 0;
        }

        @Override
        public BigInteger next() {
            int iComp = this._csr.compareTo((BigInteger)BigIntegerInterval.this.getLeftEndpoint());
            if (iComp < 0 || !BigIntegerInterval.this.isLeftClosed() && iComp == 0) {
                throw new NoSuchElementException();
            }
            BigInteger ret = this._csr;
            this._csr = this._csr.subtract((BigInteger)BigIntegerInterval.this.getStep());
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ForwardIterator
    implements Iterator<BigInteger> {
        private BigInteger _csr;

        public ForwardIterator() {
            this._csr = (BigInteger)BigIntegerInterval.this.getLeftEndpoint();
            if (!BigIntegerInterval.this.isLeftClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            int iComp = this._csr.compareTo((BigInteger)BigIntegerInterval.this.getRightEndpoint());
            return iComp < 0 || BigIntegerInterval.this.isRightClosed() && iComp == 0;
        }

        @Override
        public BigInteger next() {
            int iComp = this._csr.compareTo((BigInteger)BigIntegerInterval.this.getRightEndpoint());
            if (iComp > 0 || !BigIntegerInterval.this.isRightClosed() && iComp == 0) {
                throw new NoSuchElementException();
            }
            BigInteger ret = this._csr;
            this._csr = this._csr.add((BigInteger)BigIntegerInterval.this.getStep());
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

