/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.interval;

import gw.lang.reflect.interval.AbstractInterval;
import gw.lang.reflect.interval.IIterableInterval;
import java.util.Iterator;

public abstract class IterableInterval<E extends Comparable<E>, S, U, ME extends IterableInterval<E, S, U, ME>>
extends AbstractInterval<E, ME>
implements IIterableInterval<E, S, U, ME> {
    private S _step;
    private U _unit;

    public IterableInterval(E left, E right, S step) {
        this(left, right, step, null, true, true, false);
    }

    public IterableInterval(E left, E right, S step, U unit, boolean bLeftClosed, boolean bRightClosed, boolean bReverse) {
        super(left, right, bReverse ? bRightClosed : bLeftClosed, bReverse ? bLeftClosed : bRightClosed, bReverse);
        this._step = step;
        this._unit = unit;
    }

    @Override
    public Iterator<E> iterator() {
        if (this.isReverse()) {
            return this.iterateFromRight();
        }
        return this.iterateFromLeft();
    }

    @Override
    public S getStep() {
        return this._step;
    }

    @Override
    public ME step(S s) {
        this._step = s;
        return (ME)this;
    }

    @Override
    public U getUnit() {
        return this._unit;
    }

    @Override
    public ME unit(U u) {
        this._unit = u;
        return (ME)this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IterableInterval)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IterableInterval that = (IterableInterval)o;
        if (this._step != null ? !this._step.equals(that._step) : that._step != null) {
            return false;
        }
        return !(this._unit == null ? that._unit != null : !this._unit.equals(that._unit));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this._step != null ? this._step.hashCode() : 0);
        result = 31 * result + (this._unit != null ? this._unit.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return super.toString() + " step " + this.getStep();
    }
}

