/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.module;

import gw.lang.UnstableAPI;
import gw.lang.reflect.TypeSystem;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

@UnstableAPI
public class TypeSystemLockHelper {
    private static Boolean _bStudioRunning = null;

    private static boolean isStudioRunning() {
        if (_bStudioRunning == null) {
            _bStudioRunning = System.getProperty("gw.studio.running") != null;
        }
        return _bStudioRunning;
    }

    public static void getTypeSystemLockWithMonitor(Object objectToLock) {
        long lStart = System.currentTimeMillis();
        while (!TypeSystem.getGlobalLock().tryLock()) {
            try {
                try {
                    TypeSystemLockHelper.maybeWaitOnContextLoader(objectToLock);
                    objectToLock.wait(100L);
                }
                catch (IllegalMonitorStateException e) {
                    Thread.sleep(100L);
                }
                if (TypeSystemLockHelper.isStudioRunning() || System.currentTimeMillis() - lStart <= 1000000L) continue;
                TypeSystemLockHelper.dumpAllStackTraces(objectToLock);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void dumpAllStackTraces(Object objectToLock) {
        StringBuilder b = new StringBuilder();
        for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
            Thread thread = entry.getKey();
            b.append(thread.getName()).append('\n');
            if (TypeSystemLockHelper.isTypeSystemLockOwner(thread)) {
                b.append("!!! OWNS TYPE SYSTEM LOCK !!!\n");
            }
            if (objectToLock != null && TypeSystemLockHelper.isMonitorOwner(thread, objectToLock)) {
                b.append("!!! OWNS MONITOR: ").append(objectToLock).append("!!!\n");
            }
            for (StackTraceElement stackTraceElement : entry.getValue()) {
                b.append(stackTraceElement).append('\n');
            }
            b.append('\n');
        }
        System.err.print(b);
        throw new RuntimeException("Deadlock detected while loading classes");
    }

    private static boolean isTypeSystemLockOwner(Thread thread) {
        ReentrantLock lock = (ReentrantLock)TypeSystem.getGlobalLock();
        try {
            Method getOwner = ReentrantLock.class.getDeclaredMethod("getOwner", new Class[0]);
            getOwner.setAccessible(true);
            return getOwner.invoke((Object)lock, new Object[0]) == thread;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isMonitorOwner(Thread thread, Object monitor) {
        if (thread == Thread.currentThread() && Thread.holdsLock(monitor)) {
            return true;
        }
        ThreadInfo ti = ManagementFactory.getThreadMXBean().getThreadInfo(new long[]{thread.getId()}, true, false)[0];
        for (MonitorInfo mi : ti.getLockedMonitors()) {
            if (mi.getIdentityHashCode() != System.identityHashCode(monitor)) continue;
            return true;
        }
        return false;
    }

    private static void maybeWaitOnContextLoader(Object objectToLock) throws InterruptedException {
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        if (objectToLock != ctxLoader && ctxLoader != null) {
            try {
                ctxLoader.wait(100L);
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }
    }
}

