/*
 * Decompiled with CFR 0.152.
 */
package gw.util;

import gw.config.CommonServices;
import gw.fs.IDirectory;
import gw.fs.IFile;
import gw.fs.ResourcePath;
import gw.lang.reflect.module.IModule;
import gw.util.GosuStringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public final class Extensions {
    public static final String CONTAINS_SOURCES = "Contains-Sources";

    public static List<String> getExtensions(IDirectory dir, String headerName) {
        ArrayList<String> extensions = new ArrayList<String>();
        Extensions.getExtensions(extensions, dir, headerName);
        return extensions;
    }

    public static boolean containsManifest(IDirectory dir) {
        IFile manifestFile = dir.file("META-INF/MANIFEST.MF");
        return manifestFile != null && manifestFile.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getExtensions(Collection<String> result, IDirectory dir, String headerName) {
        IFile manifestFile = dir.file("META-INF/MANIFEST.MF");
        if (manifestFile == null || !manifestFile.exists()) {
            return;
        }
        InputStream in = null;
        try {
            in = manifestFile.openInputStream();
            Manifest manifest = new Manifest(in);
            Extensions.scanManifest(result, manifest, headerName);
        }
        catch (Exception e) {
            ResourcePath path = dir.getPath();
            String str = path != null ? path.getFileSystemPathString() : dir.toString();
            CommonServices.getEntityAccess().getLogger().warn("Cannot read manifest from jar " + str + ", ignoring");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void scanManifest(Collection<String> result, Manifest manifest, String headerName) {
        Attributes mainAttributes = manifest.getMainAttributes();
        String valueList = mainAttributes.getValue(headerName);
        if (valueList != null) {
            for (String val : valueList.split(",")) {
                result.add(GosuStringUtil.strip(val));
            }
        }
    }

    public static List<IDirectory> getJarsWithSources(IModule module) {
        ArrayList<IDirectory> jars = new ArrayList<IDirectory>();
        for (IDirectory root : module.getJavaClassPath()) {
            ArrayList<String> extensions = new ArrayList<String>();
            Extensions.getExtensions(extensions, root, CONTAINS_SOURCES);
            if (extensions.isEmpty()) continue;
            jars.add(root);
        }
        return jars;
    }

    private Extensions() {
    }
}

