/*
 * Decompiled with CFR 0.152.
 */
package gw.util;

import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class GosuClassUtil {
    public static String getNameNoPackage(String className) {
        int innerClassIndex;
        if (className == null) {
            return null;
        }
        int packageIndex = className.lastIndexOf(46) + 1;
        int index = packageIndex >= (innerClassIndex = className.lastIndexOf(36) + 1) ? packageIndex : innerClassIndex;
        return className.substring(index);
    }

    public static String getPackage(String className) {
        if (className == null || !className.contains(".")) {
            return "";
        }
        int packageIndex = className.lastIndexOf(46);
        if (packageIndex < 0) {
            return "";
        }
        return className.substring(0, packageIndex);
    }

    public static String getFileExtension(String name) {
        int iIndex = name.lastIndexOf(46);
        if (iIndex >= 0) {
            return name.substring(iIndex);
        }
        return null;
    }

    public static String getFileExtension(File file) {
        String name = file.getName();
        return GosuClassUtil.getFileExtension(name);
    }

    public static String getShortClassName(Class cls) {
        if (cls == null) {
            return "";
        }
        return GosuClassUtil.getShortClassName(cls.getName());
    }

    public static String getShortClassName(String className) {
        if (className == null) {
            return "";
        }
        if (className.length() == 0) {
            return "";
        }
        int lastDotIdx = className.lastIndexOf(".");
        int innerIdx = className.indexOf("$", lastDotIdx == -1 ? 0 : lastDotIdx + 1);
        String out = className.substring(lastDotIdx + 1);
        if (innerIdx != -1) {
            out = out.replace("$", ".");
        }
        return out;
    }

    public static Set<Class> getAllInterfaces(Class c) {
        return GosuClassUtil.getAllInterfacesImpl(c, new HashSet<Class>());
    }

    private static Set<Class> getAllInterfacesImpl(Class c, HashSet<Class> hashSet) {
        if (c == null || hashSet.contains(c)) {
            return hashSet;
        }
        if (c.isInterface()) {
            hashSet.add(c);
        }
        GosuClassUtil.getAllInterfacesImpl(c.getSuperclass(), hashSet);
        for (Class<?> iface : c.getInterfaces()) {
            GosuClassUtil.getAllInterfacesImpl(iface, hashSet);
        }
        return hashSet;
    }
}

