/*
 * Decompiled with CFR 0.152.
 */
package gw.util;

import gw.lang.parser.IExpression;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.IStatement;
import gw.lang.parser.statements.IClassDeclaration;
import gw.lang.parser.statements.IClassStatement;
import gw.lang.parser.statements.IStatementList;
import java.util.List;

public class GosuRefactorUtil {
    public static IParsedElement boundingParent(List<IParseTree> locations, int position, Class<? extends IParsedElement> ... possibleTypes) {
        IParseTree location = IParseTree.Search.getDeepestLocation(locations, position, true);
        IParsedElement pe = null;
        if (location != null) {
            for (pe = location.getParsedElement(); pe != null && !GosuRefactorUtil.isOneOfTypes(pe, possibleTypes); pe = pe.getParent()) {
            }
        }
        return pe;
    }

    private static boolean isOneOfTypes(IParsedElement pe, Class<? extends IParsedElement>[] possibleTypes) {
        for (Class<? extends IParsedElement> possibleType : possibleTypes) {
            if (!possibleType.isAssignableFrom(pe.getClass())) continue;
            return true;
        }
        return false;
    }

    public static IParseTree[] findSpanningLogicalRange(IParseTree start, IParseTree end) {
        while (end != null) {
            for (IParseTree deepestAtStart = start; deepestAtStart != null; deepestAtStart = deepestAtStart.getParent()) {
                if (!deepestAtStart.isSiblingOf(end)) continue;
                IParseTree[] returnVal = new IParseTree[]{deepestAtStart.getOffset() < end.getOffset() ? deepestAtStart : end, deepestAtStart.getExtent() > end.getExtent() ? deepestAtStart : end};
                return returnVal;
            }
            end = end.getParent();
        }
        return null;
    }

    public static MoveInstruction getMoveUpInstruction(IParseTree elementToMoveBefore) {
        return GosuRefactorUtil.findElementToMoveToBefore(elementToMoveBefore);
    }

    public static MoveInstruction getMoveDownInstruction(IParseTree elementToMoveAfter) {
        return GosuRefactorUtil.findElementToMoveToAfter(elementToMoveAfter);
    }

    private static MoveInstruction findElementToMoveToBefore(IParseTree child) {
        IParseTree parent = child.getParent();
        IParseTree precedingChild = parent.getChildBefore(child);
        if (precedingChild == null) {
            if (parent.getParsedElement() instanceof IStatementList) {
                IParseTree previousSibling = parent.getPreviousSibling();
                if (previousSibling != null && previousSibling.getParsedElement() instanceof IStatementList) {
                    return new MoveInstruction(false, false, previousSibling.getExtent());
                }
                parent = parent.getParent();
            }
            if (GosuRefactorUtil.isClassElement(parent)) {
                return null;
            }
            return new MoveInstruction(false, true, parent.getOffset());
        }
        if (precedingChild.getParsedElement() instanceof IClassDeclaration) {
            return null;
        }
        IParseTree precedingStmtList = precedingChild.getLastChildWithParsedElementType(IStatementList.class);
        if (precedingStmtList != null && !GosuRefactorUtil.isClassElement(child)) {
            return new MoveInstruction(true, false, precedingStmtList.getExtent());
        }
        return new MoveInstruction(false, false, precedingChild.getOffset());
    }

    public static boolean isClassElement(IParseTree parseTree) {
        return parseTree.getParsedElement() instanceof IClassStatement || parseTree.getParent() != null && parseTree.getParent().getParsedElement() instanceof IClassStatement;
    }

    public static MoveInstruction findElementToMoveToAfter(IParseTree child) {
        IParseTree parent = child.getParent();
        IParseTree followingChild = parent.getChildAfter(child);
        if (followingChild == null) {
            if (parent.getParsedElement() instanceof IStatementList) {
                IParseTree nextSibling = parent.getNextSibling();
                if (nextSibling != null && nextSibling.getParsedElement() instanceof IStatementList) {
                    return new MoveInstruction(false, false, nextSibling.getOffset());
                }
                parent = parent.getParent();
            }
            if (GosuRefactorUtil.isClassElement(parent)) {
                return null;
            }
            return new MoveInstruction(false, true, parent.getExtent());
        }
        IParseTree precedingStmtList = followingChild.getFirstChildWithParsedElementType(IStatementList.class);
        if (precedingStmtList != null && !GosuRefactorUtil.isClassElement(child)) {
            return new MoveInstruction(true, false, precedingStmtList.getOffset());
        }
        return new MoveInstruction(false, false, followingChild.getExtent());
    }

    public static IParseTree findFirstStatementAtLine(int line, int position, List<IParseTree> locations) {
        return GosuRefactorUtil.findStatementAtLine(locations, position, line, true);
    }

    public static IParseTree findLastStatementAtLine(int line, int position, List<IParseTree> locations) {
        return GosuRefactorUtil.findStatementAtLine(locations, position, line, false);
    }

    private static IParseTree findStatementAtLine(List<IParseTree> locations, int position, int line, boolean earliest) {
        for (IParseTree location : locations) {
            IParseTree deepestLocation = location.getDeepestLocation(position, true);
            if (deepestLocation == null) continue;
            while (deepestLocation != null && !(deepestLocation.getParsedElement() instanceof IStatement)) {
                deepestLocation = deepestLocation.getParent();
            }
            if (deepestLocation == null) continue;
            if (deepestLocation.getLineNum() == line) {
                deepestLocation = deepestLocation.getParent();
            }
            List<IParseTree> list = deepestLocation.getChildren();
            IParseTree closestChildOnLine = null;
            for (IParseTree parseTree : list) {
                if (parseTree.getParsedElement() instanceof IStatementList || parseTree.getParsedElement() instanceof IExpression || parseTree.getLineNum() != line) continue;
                if (closestChildOnLine == null) {
                    closestChildOnLine = parseTree;
                    continue;
                }
                if (earliest && parseTree.getOffset() < closestChildOnLine.getOffset()) {
                    closestChildOnLine = parseTree;
                    continue;
                }
                if (parseTree.getOffset() <= closestChildOnLine.getOffset()) continue;
                closestChildOnLine = parseTree;
            }
            if (closestChildOnLine != null) {
                return closestChildOnLine;
            }
            if (deepestLocation.getParsedElement() instanceof IStatementList) {
                return deepestLocation.getParent();
            }
            if (deepestLocation.getParsedElement() instanceof IClassStatement) {
                return null;
            }
            return deepestLocation;
        }
        return null;
    }

    public static class MoveInstruction {
        public boolean indent;
        public boolean outdent;
        public int position;

        public MoveInstruction(boolean indent, boolean outdent, int position) {
            this.indent = indent;
            this.outdent = outdent;
            this.position = position;
        }
    }
}

