/*
 * Decompiled with CFR 0.152.
 */
package gw.xml.simple;

import gw.xml.simple.SimpleXmlNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

class XmlChildList<T extends SimpleXmlNode>
implements List<T> {
    private List<T> _delegate = new ArrayList<T>();
    private SimpleXmlNode _owner;

    public XmlChildList(SimpleXmlNode owner) {
        this._owner = owner;
    }

    @Override
    public int size() {
        return this._delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this._delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this._delegate.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return new WrappingIterator(this._delegate.iterator());
    }

    @Override
    public Object[] toArray() {
        return this._delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this._delegate.toArray(a);
    }

    @Override
    public boolean add(T t) {
        this.validateArgumentForAdd(t, "XmlChildList.add()");
        ((SimpleXmlNode)t).setParent(this._owner);
        return this._delegate.add(t);
    }

    @Override
    public boolean remove(Object o) {
        boolean result = this._delegate.remove(o);
        if (result) {
            ((SimpleXmlNode)o).setParent(null);
        }
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this._delegate.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.validateArgumentsForAdd(c, "addAll(Collection)");
        this.setParents(c);
        return this._delegate.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        this.validateArgumentsForAdd(c, "addAll(int, Collection)");
        this.setParents(c);
        return this._delegate.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (int i = 0; i < this._delegate.size(); ++i) {
            if (!c.contains(this._delegate.get(i))) continue;
            this.remove(i);
            --i;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        for (int i = 0; i < this._delegate.size(); ++i) {
            if (c.contains(this._delegate.get(i))) continue;
            this.remove(i);
            --i;
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        for (SimpleXmlNode node : this._delegate) {
            node.setParent(null);
        }
        this._delegate.clear();
    }

    @Override
    public T get(int index) {
        return (T)((SimpleXmlNode)this._delegate.get(index));
    }

    @Override
    public T set(int index, T element) {
        SimpleXmlNode original;
        this.validateArgumentForSet(element, "XmlChildList.set(int, T)");
        if (((SimpleXmlNode)element).getParent() == null) {
            ((SimpleXmlNode)element).setParent(this._owner);
        }
        if (!this.contains(original = (SimpleXmlNode)this._delegate.set(index, element))) {
            original.setParent(null);
        }
        return (T)original;
    }

    @Override
    public void add(int index, T element) {
        this.validateArgumentForAdd(element, "XmlChildList.add(int, T)");
        ((SimpleXmlNode)element).setParent(this._owner);
        this._delegate.add(index, element);
    }

    @Override
    public T remove(int index) {
        SimpleXmlNode result = (SimpleXmlNode)this._delegate.remove(index);
        result.setParent(null);
        return (T)result;
    }

    @Override
    public int indexOf(Object o) {
        return this._delegate.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this._delegate.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new WrappingListIterator(this._delegate.listIterator());
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new WrappingListIterator(this._delegate.listIterator(index));
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("XmlChildList.subList(int, int) is not currently supported");
    }

    private void setParents(Collection<? extends T> c) {
        for (SimpleXmlNode arg : c) {
            arg.setParent(this._owner);
        }
    }

    private void validateArgumentsForAdd(Collection<? extends T> c, String functionName) {
        for (SimpleXmlNode arg : c) {
            this.validateArgumentForAdd(arg, functionName);
        }
    }

    private void validateArgumentForAdd(T arg, String functionName) {
        if (arg == null) {
            throw new IllegalArgumentException(functionName + " cannot be called with a null argument");
        }
        if (((SimpleXmlNode)arg).getParent() != null) {
            throw new IllegalArgumentException(functionName + " cannot be called with an argument that already has a non-null parent");
        }
    }

    private void validateArgumentForSet(T element, String functionName) {
        if (element == null) {
            throw new IllegalArgumentException(functionName + " cannot be called with a null argument");
        }
        if (((SimpleXmlNode)element).getParent() != null && ((SimpleXmlNode)element).getParent() != this._owner) {
            throw new IllegalArgumentException(functionName + " cannot be called with an element that has a non-null parent unless that parent is already set to the owner of this list");
        }
    }

    private class WrappingListIterator
    implements ListIterator<T> {
        private ListIterator<T> _wrapped;
        private T _lastRet;

        private WrappingListIterator(ListIterator<T> wrapped) {
            this._wrapped = wrapped;
        }

        @Override
        public boolean hasNext() {
            return this._wrapped.hasNext();
        }

        @Override
        public T next() {
            this._lastRet = (SimpleXmlNode)this._wrapped.next();
            return this._lastRet;
        }

        @Override
        public boolean hasPrevious() {
            return this._wrapped.hasPrevious();
        }

        @Override
        public T previous() {
            this._lastRet = (SimpleXmlNode)this._wrapped.previous();
            return this._lastRet;
        }

        @Override
        public int nextIndex() {
            return this._wrapped.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this._wrapped.previousIndex();
        }

        @Override
        public void remove() {
            this._wrapped.remove();
            ((SimpleXmlNode)this._lastRet).setParent(null);
        }

        @Override
        public void set(T t) {
            XmlChildList.this.validateArgumentForSet(t, "WrappingListIterator.set(T)");
            this._wrapped.set(t);
            if (((SimpleXmlNode)t).getParent() == null) {
                ((SimpleXmlNode)t).setParent(XmlChildList.this._owner);
            }
            if (!XmlChildList.this.contains(this._lastRet)) {
                ((SimpleXmlNode)this._lastRet).setParent(null);
            }
        }

        @Override
        public void add(T t) {
            XmlChildList.this.validateArgumentForAdd(t, "WrappingListIterator.add(T)");
            this._wrapped.add(t);
            ((SimpleXmlNode)t).setParent(XmlChildList.this._owner);
        }
    }

    private class WrappingIterator
    implements Iterator<T> {
        private Iterator<T> _wrapped;
        private T _lastRet;

        private WrappingIterator(Iterator<T> wrapped) {
            this._wrapped = wrapped;
        }

        @Override
        public boolean hasNext() {
            return this._wrapped.hasNext();
        }

        @Override
        public T next() {
            this._lastRet = (SimpleXmlNode)this._wrapped.next();
            return this._lastRet;
        }

        @Override
        public void remove() {
            this._wrapped.remove();
            ((SimpleXmlNode)this._lastRet).setParent(null);
        }
    }
}

